/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.stream.Stream;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.los.TimeIndependentLOSTransform;
import org.orekit.rugged.utils.DSGenerator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FixedRotation
implements TimeIndependentLOSTransform {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-20);
    private final Vector3D axis;
    private Rotation rotation;
    private FieldRotation<DerivativeStructure> rDS;
    private final ParameterDriver angleDriver;

    public FixedRotation(String name, Vector3D axis, double angle) {
        this.axis = axis;
        this.rotation = null;
        this.rDS = null;
        this.angleDriver = new ParameterDriver(name, angle, this.SCALE, Math.PI * -2, Math.PI * 2);
        this.angleDriver.addObserver(new ParameterObserver(){

            public void valueChanged(double previousValue, ParameterDriver driver) {
                FixedRotation.this.rotation = null;
                FixedRotation.this.rDS = null;
            }
        });
    }

    @Override
    public Stream<ParameterDriver> getParametersDrivers() {
        return Stream.of(this.angleDriver);
    }

    @Override
    public Vector3D transformLOS(int i, Vector3D los) {
        if (this.rotation == null) {
            this.rotation = new Rotation(this.axis, this.angleDriver.getValue(), RotationConvention.VECTOR_OPERATOR);
        }
        return this.rotation.applyTo(los);
    }

    @Override
    public FieldVector3D<DerivativeStructure> transformLOS(int i, FieldVector3D<DerivativeStructure> los, DSGenerator generator) {
        if (this.rDS == null) {
            FieldVector3D axisDS = new FieldVector3D((RealFieldElement)generator.constant(this.axis.getX()), (RealFieldElement)generator.constant(this.axis.getY()), (RealFieldElement)generator.constant(this.axis.getZ()));
            DerivativeStructure angleDS = generator.variable(this.angleDriver);
            this.rDS = new FieldRotation(axisDS, (RealFieldElement)angleDS, RotationConvention.VECTOR_OPERATOR);
        }
        return this.rDS.applyTo(los);
    }
}

