/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;

public class FieldFixedNumberInterpolationGrid<T extends RealFieldElement<T>>
implements FieldInterpolationGrid<T> {
    private final int pointsPerStep;
    private final Field<T> field;

    public FieldFixedNumberInterpolationGrid(Field<T> field, int pointsPerStep) {
        this.field = field;
        this.pointsPerStep = pointsPerStep;
    }

    @Override
    public T[] getGridPoints(T stepStart, T stepEnd) {
        RealFieldElement[] grid = (RealFieldElement[])MathArrays.buildArray(this.field, (int)this.pointsPerStep);
        RealFieldElement stepSize = (RealFieldElement)((RealFieldElement)stepEnd.subtract(stepStart)).divide((double)(this.pointsPerStep - 1));
        for (int i = 0; i < this.pointsPerStep; ++i) {
            grid[i] = (RealFieldElement)((RealFieldElement)stepSize.multiply(i)).add(stepStart);
        }
        return grid;
    }
}

