/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.leastsquares.DSSTBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.DSSTKalmanModel;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.IntegratedPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class DSSTPropagatorBuilder
extends AbstractPropagatorBuilder
implements IntegratedPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<DSSTForceModel> forceModels;
    private double mass;
    private AttitudeProvider attProvider;
    private PropagationType propagationType;
    private PropagationType stateType;

    public DSSTPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, double positionScale, PropagationType propagationType, PropagationType stateType) {
        super(referenceOrbit, PositionAngle.MEAN, positionScale, true);
        this.builder = builder;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.mass = 1000.0;
        this.attProvider = Propagator.DEFAULT_LAW;
        this.propagationType = propagationType;
        this.stateType = stateType;
    }

    public DSSTPropagatorBuilder copy() {
        DSSTPropagatorBuilder copyBuilder = new DSSTPropagatorBuilder((EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(this.createInitialOrbit()), this.builder, this.getPositionScale(), this.propagationType, this.stateType);
        copyBuilder.setAttitudeProvider(this.attProvider);
        copyBuilder.setMass(this.mass);
        for (DSSTForceModel model : this.forceModels) {
            copyBuilder.addForceModel(model);
        }
        return copyBuilder;
    }

    public ODEIntegratorBuilder getIntegratorBuilder() {
        return this.builder;
    }

    public List<DSSTForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attProvider;
    }

    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attProvider = attitudeProvider;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void addForceModel(DSSTForceModel model) {
        this.forceModels.add(model);
        for (ParameterDriver driver : model.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
    }

    @Override
    public DSSTPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        EquinoctialOrbit orbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(this.createInitialOrbit());
        Attitude attitude = this.attProvider.getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState((Orbit)orbit, attitude, this.mass);
        DSSTPropagator propagator = new DSSTPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, OrbitType.EQUINOCTIAL), this.propagationType);
        propagator.setAttitudeProvider(this.attProvider);
        for (DSSTForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.setInitialState(state, this.stateType);
        return propagator;
    }

    @Override
    public DSSTBatchLSModel buildLSModel(IntegratedPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new DSSTBatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer, this.propagationType, this.stateType);
    }

    @Override
    public DSSTKalmanModel buildKalmanModel(List<IntegratedPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters) {
        return new DSSTKalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, this.propagationType, this.stateType);
    }
}

