/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.Map;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class KeplerianPropagator
extends AbstractAnalyticalPropagator {
    private SpacecraftState initialState;
    private TimeSpanMap<SpacecraftState> states;

    public KeplerianPropagator(Orbit initialOrbit) {
        this(initialOrbit, DEFAULT_LAW, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, double mu) {
        this(initialOrbit, DEFAULT_LAW, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv) {
        this(initialOrbit, attitudeProv, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu) {
        this(initialOrbit, attitudeProv, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu, double mass) {
        super(attitudeProv);
        this.initialState = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, Collections.emptyMap());
        this.states = new TimeSpanMap<SpacecraftState>(this.initialState);
        super.resetInitialState(this.initialState);
    }

    private SpacecraftState fixState(Orbit orbit, Attitude attitude, double mass, double mu, Map<String, double[]> additionalStates) {
        OrbitType type = orbit.getType();
        double[] stateVector = new double[6];
        type.mapOrbitToArray(orbit, PositionAngle.TRUE, stateVector, null);
        Orbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, orbit.getDate(), mu, orbit.getFrame());
        SpacecraftState fixedState = new SpacecraftState(fixedOrbit, attitude, mass);
        for (Map.Entry<String, double[]> entry : additionalStates.entrySet()) {
            fixedState = fixedState.addAdditionalState(entry.getKey(), entry.getValue());
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        SpacecraftState fixedState;
        double mu = this.initialState == null ? state.getMu() : this.initialState.getMu();
        this.initialState = fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStates());
        this.states = new TimeSpanMap<SpacecraftState>(this.initialState);
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate());
        } else {
            this.states.addValidBefore(state, state.getDate());
        }
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        Orbit orbit = this.states.get(date).getOrbit();
        while (!date.equals((orbit = orbit.shiftedBy(date.durationFrom(orbit.getDate()))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.states.get(date).getMass();
    }
}

