/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.modifiers.TroposphericDSConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class TurnAroundRangeTroposphericDelayModifier
implements EstimationModifier<TurnAroundRange> {
    private final DiscreteTroposphericModel tropoModel;

    public TurnAroundRangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    private double getStationHeightAMSL(GroundStation station) {
        double height = station.getBaseFrame().getPoint().getAltitude();
        return height;
    }

    private <T extends RealFieldElement<T>> T getStationHeightAMSL(Field<T> field, GroundStation station) {
        T height = station.getBaseFrame().getPoint(field).getAltitude();
        return height;
    }

    private double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double height = this.getStationHeightAMSL(station);
            double delay = this.tropoModel.pathDelay(elevation, height, this.tropoModel.getParameters(), state.getDate());
            return delay;
        }
        return 0.0;
    }

    private <T extends RealFieldElement<T>> T rangeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object dsElevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (dsElevation.getReal() > 0.0) {
            T height = this.getStationHeightAMSL(field, station);
            RealFieldElement delay = this.tropoModel.pathDelay((RealFieldElement)dsElevation, (RealFieldElement)height, (RealFieldElement[])parameters, state.getDate());
            return (T)delay;
        }
        return (T)zero;
    }

    private double[][] rangeErrorJacobianState(double[] derivatives, int freeStateParameters) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        for (int i = 0; i < freeStateParameters; ++i) {
            finiteDifferencesJacobian[0][i] = derivatives[i + 1];
        }
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return TurnAroundRangeTroposphericDelayModifier.this.rangeErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - 1 - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[1 + freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) {
        double parameterDerivative;
        TurnAroundRange measurement = estimated.getObservedMeasurement();
        GroundStation masterStation = measurement.getMasterStation();
        GroundStation slaveStation = measurement.getSlaveStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        TroposphericDSConverter converter = new TroposphericDSConverter(state, 6, Propagator.DEFAULT_LAW);
        FieldSpacecraftState<DerivativeStructure> dsState = converter.getState(this.tropoModel);
        DerivativeStructure[] dsParameters = converter.getParameters(dsState, this.tropoModel);
        DerivativeStructure masterDSDelay = (DerivativeStructure)this.rangeErrorTroposphericModel(masterStation, dsState, (RealFieldElement[])dsParameters);
        DerivativeStructure slaveDSDelay = (DerivativeStructure)this.rangeErrorTroposphericModel(slaveStation, dsState, (RealFieldElement[])dsParameters);
        double[] masterDerivatives = masterDSDelay.getAllDerivatives();
        double[] slaveDerivatives = masterDSDelay.getAllDerivatives();
        double[][] masterDjac = this.rangeErrorJacobianState(masterDerivatives, converter.getFreeStateParameters());
        double[][] slaveDjac = this.rangeErrorJacobianState(slaveDerivatives, converter.getFreeStateParameters());
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + (masterDjac[irow][jcol] + slaveDjac[irow][jcol]);
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int indexMaster = 0;
        for (ParameterDriver parameterDriver : this.getParametersDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            double parameterDerivative2 = estimated.getParameterDerivatives(parameterDriver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(masterDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(parameterDriver, parameterDerivative2 += derivatives[indexMaster]);
            ++indexMaster;
        }
        int indexSlave = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(slaveDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += derivatives[indexSlave]);
            ++indexSlave;
        }
        for (ParameterDriver driver : Arrays.asList(masterStation.getClockOffsetDriver(), masterStation.getEastOffsetDriver(), masterStation.getNorthOffsetDriver(), masterStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(masterStation, driver, state));
        }
        for (ParameterDriver driver : Arrays.asList(slaveStation.getEastOffsetDriver(), slaveStation.getNorthOffsetDriver(), slaveStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(slaveStation, driver, state));
        }
        double[] dArray = (double[])oldValue.clone();
        dArray[0] = dArray[0] + masterDSDelay.getReal() + slaveDSDelay.getReal();
        estimated.setEstimatedValue(dArray);
    }
}

