/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.GeoMagneticFieldFactory;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class MagneticFieldDetector
extends AbstractDetector<MagneticFieldDetector> {
    private final double limit;
    private final boolean seaLevel;
    private GeoMagneticField field;
    private double currentYear;
    private final GeoMagneticFieldFactory.FieldModel type;
    private final OneAxisEllipsoid body;
    private final TimeScale timeScale;

    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, limit, type, body, false);
    }

    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, limit, type, body, seaLevel);
    }

    public MagneticFieldDetector(double maxCheck, double threshold, double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel) throws OrekitIllegalArgumentException {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), limit, type, body, seaLevel);
    }

    private MagneticFieldDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super MagneticFieldDetector> handler, double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel) throws OrekitIllegalArgumentException {
        super(maxCheck, threshold, maxIter, handler);
        this.limit = limit;
        this.type = type;
        this.body = body;
        this.seaLevel = seaLevel;
        this.timeScale = TimeScalesFactory.getUTC();
    }

    @Override
    protected MagneticFieldDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super MagneticFieldDetector> newHandler) {
        try {
            return new MagneticFieldDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.limit, this.type, this.body, this.seaLevel);
        }
        catch (OrekitException e) {
            return null;
        }
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        this.currentYear = s0.getDate().getComponents(this.timeScale).getDate().getYear();
        this.field = GeoMagneticFieldFactory.getField(this.type, this.currentYear);
    }

    @Override
    public double g(SpacecraftState s) {
        try {
            if ((double)s.getDate().getComponents(this.timeScale).getDate().getYear() != this.currentYear) {
                this.currentYear = s.getDate().getComponents(this.timeScale).getDate().getYear();
                this.field = GeoMagneticFieldFactory.getField(this.type, this.currentYear);
            }
            GeodeticPoint geoPoint = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
            double altitude = this.seaLevel ? 0.0 : geoPoint.getAltitude();
            double value = this.field.calculateField(geoPoint.getLatitude(), geoPoint.getLongitude(), altitude).getTotalIntensity();
            return value - this.limit;
        }
        catch (OrekitException e) {
            e.printStackTrace();
            return -1.0;
        }
    }
}

