/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.gnss.AbstractGNSSPropagator;
import org.orekit.propagation.analytical.gnss.GPSOrbitalElements;
import org.orekit.utils.IERSConventions;

public class GPSPropagator
extends AbstractGNSSPropagator {
    private static final double GPS_AV = 7.2921151467E-5;
    private static final double GPS_CYCLE_DURATION = 6.193152E8;
    private final GPSOrbitalElements gpsOrbit;

    private GPSPropagator(Builder builder) {
        super(builder.orbit, builder.attitudeProvider, builder.eci, builder.ecef, builder.mass, 7.2921151467E-5, 6.193152E8, 3.986005E14);
        this.gpsOrbit = builder.orbit;
    }

    public GPSOrbitalElements getGPSOrbitalElements() {
        return this.gpsOrbit;
    }

    public static class Builder {
        private final GPSOrbitalElements orbit;
        private AttitudeProvider attitudeProvider = Propagator.DEFAULT_LAW;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(GPSOrbitalElements gpsOrbElt) {
            this.orbit = gpsOrbElt;
            this.eci = FramesFactory.getEME2000();
            this.ecef = FramesFactory.getITRF(IERSConventions.IERS_2010, true);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public GPSPropagator build() {
            return new GPSPropagator(this);
        }
    }
}

