/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.IterativeLinearSolverEvent;
import org.hipparchus.linear.RealVector;

public class DefaultIterativeLinearSolverEvent
extends IterativeLinearSolverEvent {
    private static final long serialVersionUID = 20120129L;
    private final RealVector b;
    private final RealVector r;
    private final double rnorm;
    private final RealVector x;

    public DefaultIterativeLinearSolverEvent(Object source, int iterations, RealVector x, RealVector b, RealVector r, double rnorm) {
        super(source, iterations);
        this.x = x;
        this.b = b;
        this.r = r;
        this.rnorm = rnorm;
    }

    public DefaultIterativeLinearSolverEvent(Object source, int iterations, RealVector x, RealVector b, double rnorm) {
        super(source, iterations);
        this.x = x;
        this.b = b;
        this.r = null;
        this.rnorm = rnorm;
    }

    @Override
    public double getNormOfResidual() {
        return this.rnorm;
    }

    @Override
    public RealVector getResidual() {
        if (this.r != null) {
            return this.r;
        }
        throw new MathRuntimeException(LocalizedCoreFormats.UNSUPPORTED_OPERATION, new Object[0]);
    }

    @Override
    public RealVector getRightHandSideVector() {
        return this.b;
    }

    @Override
    public RealVector getSolution() {
        return this.x;
    }

    @Override
    public boolean providesResidual() {
        return this.r != null;
    }
}

