/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class TroposphericDSConverter {
    private final int freeStateParameters;
    private final List<FieldSpacecraftState<DerivativeStructure>> dsStates;

    public TroposphericDSConverter(SpacecraftState state, int freeStateParameters, AttitudeProvider provider) {
        this.freeStateParameters = freeStateParameters;
        DSFactory factory = new DSFactory(freeStateParameters, 1);
        Vector3D pos = state.getPVCoordinates().getPosition();
        FieldVector3D posDS = new FieldVector3D((RealFieldElement)factory.variable(0, pos.getX()), (RealFieldElement)factory.variable(1, pos.getY()), (RealFieldElement)factory.variable(2, pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velDS = freeStateParameters > 3 ? new FieldVector3D((RealFieldElement)factory.variable(3, vel.getX()), (RealFieldElement)factory.variable(4, vel.getY()), (RealFieldElement)factory.variable(5, vel.getZ())) : new FieldVector3D((RealFieldElement)factory.constant(vel.getX()), (RealFieldElement)factory.constant(vel.getY()), (RealFieldElement)factory.constant(vel.getZ()));
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accDS = new FieldVector3D((RealFieldElement)factory.constant(acc.getX()), (RealFieldElement)factory.constant(acc.getY()), (RealFieldElement)factory.constant(acc.getZ()));
        DerivativeStructure dsM = factory.constant(state.getMass());
        FieldCartesianOrbit<DerivativeStructure> dsOrbit = new FieldCartesianOrbit<DerivativeStructure>(new TimeStampedFieldPVCoordinates(state.getDate(), posDS, velDS, accDS), state.getFrame(), ((DerivativeStructure)factory.getDerivativeField().getZero()).add(state.getMu()));
        FieldAttitude<Object> dsAttitude = freeStateParameters > 3 ? provider.getAttitude(dsOrbit, dsOrbit.getDate(), dsOrbit.getFrame()) : new FieldAttitude(factory.getDerivativeField(), state.getAttitude());
        this.dsStates = new ArrayList<FieldSpacecraftState<DerivativeStructure>>();
        this.dsStates.add(new FieldSpacecraftState<DerivativeStructure>(dsOrbit, dsAttitude, dsM));
    }

    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    public FieldSpacecraftState<DerivativeStructure> getState(DiscreteTroposphericModel tropoModel) {
        int nbParams = 0;
        for (ParameterDriver driver : tropoModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.dsStates.size() < nbParams + 1) {
            this.dsStates.add(null);
        }
        if (this.dsStates.get(nbParams) == null) {
            DSFactory factory = new DSFactory(this.freeStateParameters + nbParams, 1);
            FieldSpacecraftState<DerivativeStructure> s0 = this.dsStates.get(0);
            TimeStampedFieldPVCoordinates<DerivativeStructure> pv0 = s0.getPVCoordinates();
            FieldCartesianOrbit<DerivativeStructure> dsOrbit = new FieldCartesianOrbit<DerivativeStructure>(new TimeStampedFieldPVCoordinates<DerivativeStructure>(s0.getDate().toAbsoluteDate(), this.extend(pv0.getPosition(), factory), this.extend(pv0.getVelocity(), factory), this.extend(pv0.getAcceleration(), factory)), s0.getFrame(), this.extend(s0.getMu(), factory));
            TimeStampedFieldAngularCoordinates<DerivativeStructure> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<DerivativeStructure> dsAttitude = new FieldAttitude<DerivativeStructure>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<DerivativeStructure>(dsOrbit.getDate(), this.extend(ac0.getRotation(), factory), this.extend(ac0.getRotationRate(), factory), this.extend(ac0.getRotationAcceleration(), factory)));
            DerivativeStructure dsM = this.extend(s0.getMass(), factory);
            this.dsStates.set(nbParams, new FieldSpacecraftState<DerivativeStructure>(dsOrbit, dsAttitude, dsM));
        }
        return this.dsStates.get(nbParams);
    }

    private DerivativeStructure extend(DerivativeStructure original, DSFactory factory) {
        double[] originalDerivatives = original.getAllDerivatives();
        double[] extendedDerivatives = new double[factory.getCompiler().getSize()];
        System.arraycopy(originalDerivatives, 0, extendedDerivatives, 0, originalDerivatives.length);
        return factory.build(extendedDerivatives);
    }

    private FieldVector3D<DerivativeStructure> extend(FieldVector3D<DerivativeStructure> original, DSFactory factory) {
        return new FieldVector3D((RealFieldElement)this.extend((DerivativeStructure)original.getX(), factory), (RealFieldElement)this.extend((DerivativeStructure)original.getY(), factory), (RealFieldElement)this.extend((DerivativeStructure)original.getZ(), factory));
    }

    private FieldRotation<DerivativeStructure> extend(FieldRotation<DerivativeStructure> original, DSFactory factory) {
        return new FieldRotation((RealFieldElement)this.extend((DerivativeStructure)original.getQ0(), factory), (RealFieldElement)this.extend((DerivativeStructure)original.getQ1(), factory), (RealFieldElement)this.extend((DerivativeStructure)original.getQ2(), factory), (RealFieldElement)this.extend((DerivativeStructure)original.getQ3(), factory), false);
    }

    public DerivativeStructure[] getParameters(FieldSpacecraftState<DerivativeStructure> state, DiscreteTroposphericModel tropoModel) {
        DSFactory factory = state.getMass().getFactory();
        List<ParameterDriver> drivers = tropoModel.getParametersDrivers();
        DerivativeStructure[] parameters = new DerivativeStructure[drivers.size()];
        int index = this.freeStateParameters;
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).isSelected() ? factory.variable(index++, drivers.get(i).getValue()) : factory.constant(drivers.get(i).getValue());
        }
        return parameters;
    }
}

