/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;

public class UpperBounds {
    private UpperBounds() {
    }

    public static double getDnl(double xx, double xpl, int n, int l) {
        int lp2 = l + 2;
        if (n > lp2) {
            double dM;
            int ll = l * l;
            double dL = dM = xpl;
            double dB = (double)(l + 1) * xx * xpl;
            for (int j = l + 3; j <= n; ++j) {
                int jm1 = j - 1;
                dL = dM;
                dM = dB;
                dB = (double)jm1 * xx * ((double)(2 * j - 3) * dM - (double)(j - 2) * dL) / (double)(jm1 * jm1 - ll);
            }
            return dB;
        }
        if (n == lp2) {
            return (double)(l + 1) * xx * xpl;
        }
        return xpl;
    }

    public static <T extends RealFieldElement<T>> T getDnl(T xx, T xpl, int n, int l) {
        int lp2 = l + 2;
        if (n > lp2) {
            Object dM;
            int ll = l * l;
            T dL = dM = xpl;
            RealFieldElement dB = (RealFieldElement)((RealFieldElement)xx.multiply(xpl)).multiply(l + 1);
            for (int j = l + 3; j <= n; ++j) {
                int jm1 = j - 1;
                dL = dM;
                dM = dB;
                dB = (RealFieldElement)((RealFieldElement)((RealFieldElement)xx.multiply(jm1)).multiply(((RealFieldElement)dM.multiply(2 * j - 3)).subtract(dL.multiply(j - 2)))).divide((double)(jm1 * jm1 - ll));
            }
            return (T)dB;
        }
        if (n == lp2) {
            return (T)((RealFieldElement)((RealFieldElement)xx.multiply(xpl)).multiply(l + 1));
        }
        return xpl;
    }

    public static double getRnml(double gamma, int n, int l, int m, int eps, int irf) {
        int mei = m * eps * irf;
        double sinisq = 1.0 - gamma * gamma;
        double sininc = FastMath.max((double)0.03, (double)FastMath.sqrt((double)sinisq));
        double onepig = 1.0 + gamma * (double)irf;
        double sinincPowLmMEI = FastMath.pow((double)sininc, (int)(l - mei));
        double onepigPowLmMEI = FastMath.pow((double)onepig, (int)mei);
        double rBound = sinincPowLmMEI * onepigPowLmMEI;
        if (n > l) {
            int lp1 = l + 1;
            double dpnml = lp1 * eps;
            double pnml = dpnml * gamma - (double)m;
            if (n > l + 1) {
                int ll = l * l;
                int ml = m * l;
                int mm = m * m;
                double pn1ml = 1.0;
                double dpn1ml = 0.0;
                double pn2ml = 1.0;
                double dpn2ml = 0.0;
                for (int in = l + 2; in <= n; ++in) {
                    int nm1 = in - 1;
                    int tnm1 = in + nm1;
                    int nnlnl = nm1 * (in * in - ll);
                    int nnmnm = in * (nm1 * nm1 - mm);
                    int c2nne = tnm1 * in * nm1 * eps;
                    int c2nml = tnm1 * ml;
                    double coef = (double)c2nne * gamma - (double)c2nml;
                    pn2ml = pn1ml;
                    dpn2ml = dpn1ml;
                    pn1ml = pnml;
                    dpn1ml = dpnml;
                    pnml = (coef * pn1ml - (double)nnmnm * pn2ml) / (double)nnlnl;
                    dpnml = (coef * dpn1ml - (double)nnmnm * dpn2ml + (double)c2nne * pn1ml) / (double)nnlnl;
                }
            }
            rBound *= FastMath.sqrt((double)(pnml * pnml + dpnml * dpnml * sinisq / (double)((n - l) * (n + lp1))));
        }
        return rBound;
    }

    public static <T extends RealFieldElement<T>> T getRnml(T gamma, int n, int l, int m, int eps, int irf) {
        RealFieldElement zero = (RealFieldElement)gamma.getField().getZero();
        int mei = m * eps * irf;
        RealFieldElement sinisq = (RealFieldElement)((RealFieldElement)((RealFieldElement)gamma.multiply(gamma)).negate()).add(1.0);
        RealFieldElement sininc = FastMath.max((RealFieldElement)((RealFieldElement)zero.add(0.03)), (RealFieldElement)FastMath.sqrt((RealFieldElement)sinisq));
        RealFieldElement onepig = (RealFieldElement)((RealFieldElement)gamma.multiply(irf)).add(1.0);
        RealFieldElement sinincPowLmMEI = FastMath.pow((RealFieldElement)sininc, (int)(l - mei));
        RealFieldElement onepigPowLmMEI = FastMath.pow((RealFieldElement)onepig, (int)mei);
        RealFieldElement rBound = (RealFieldElement)sinincPowLmMEI.multiply((Object)onepigPowLmMEI);
        if (n > l) {
            int lp1 = l + 1;
            RealFieldElement dpnml = (RealFieldElement)zero.add((double)(lp1 * eps));
            RealFieldElement pnml = (RealFieldElement)((RealFieldElement)gamma.multiply((Object)dpnml)).subtract((double)m);
            if (n > l + 1) {
                int ll = l * l;
                int ml = m * l;
                int mm = m * m;
                RealFieldElement pn1ml = (RealFieldElement)zero.add(1.0);
                RealFieldElement dpn1ml = zero;
                RealFieldElement pn2ml = (RealFieldElement)zero.add(1.0);
                RealFieldElement dpn2ml = zero;
                for (int in = l + 2; in <= n; ++in) {
                    int nm1 = in - 1;
                    int tnm1 = in + nm1;
                    int nnlnl = nm1 * (in * in - ll);
                    int nnmnm = in * (nm1 * nm1 - mm);
                    int c2nne = tnm1 * in * nm1 * eps;
                    int c2nml = tnm1 * ml;
                    RealFieldElement coef = (RealFieldElement)((RealFieldElement)gamma.multiply(c2nne)).subtract((double)c2nml);
                    pn2ml = pn1ml;
                    dpn2ml = dpn1ml;
                    pn1ml = pnml;
                    dpn1ml = dpnml;
                    pnml = (RealFieldElement)((RealFieldElement)((RealFieldElement)coef.multiply((Object)pn1ml)).subtract(pn2ml.multiply(nnmnm))).divide((double)nnlnl);
                    dpnml = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)coef.multiply((Object)dpn1ml)).subtract(dpn2ml.multiply(nnmnm))).add(pn1ml.multiply(c2nne))).divide((double)nnlnl);
                }
            }
            rBound = (RealFieldElement)rBound.multiply((Object)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)pnml.multiply((Object)pnml)).add(((RealFieldElement)((RealFieldElement)dpnml.multiply((Object)dpnml)).multiply((Object)sinisq)).divide((double)((n - l) * (n + lp1)))))));
        }
        return (T)rBound;
    }
}

