/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.GLONASSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GLONASSDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;

public class GLONASSAnalyticalPropagator
extends AbstractAnalyticalPropagator {
    private static final double SEVEN_THIRD = 2.3333333333333335;
    private static final double SEVEN_SIXTH = 1.1666666666666667;
    private static final double SEVEN_24TH = 0.2916666666666667;
    private static final double FN_72TH = 0.6805555555555556;
    private static final double GLONASS_AV = 7.292115E-5;
    private static final double GLONASS_MEAN_INCLINATION = 64.8;
    private static final double GLONASS_MEAN_DRACONIAN_PERIOD = 40544.0;
    private static final double GLONASS_J20 = 0.00108262575;
    private static final double GLONASS_EARTH_EQUATORIAL_RADIUS = 6378136.0;
    private static final double A;
    private static final double B;
    private final GLONASSOrbitalElements glonassOrbit;
    private final double mass;
    private final Frame eci;
    private final Frame ecef;
    private final DSFactory factory;

    private GLONASSAnalyticalPropagator(Builder builder) {
        super(builder.attitudeProvider);
        this.glonassOrbit = builder.orbit;
        this.setStartDate(this.glonassOrbit.getDate());
        this.mass = builder.mass;
        this.eci = builder.eci;
        this.ecef = builder.ecef;
        this.factory = new DSFactory(1, 2);
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        DerivativeStructure dTpr = this.getdTpr(date);
        DerivativeStructure zero = (DerivativeStructure)dTpr.getField().getZero();
        DerivativeStructure w = (DerivativeStructure)FastMath.floor((RealFieldElement)dTpr.divide(40544.0 + this.glonassOrbit.getDeltaT()));
        DerivativeStructure i = zero.add(1.1309733552923245 + this.glonassOrbit.getDeltaI());
        DerivativeStructure e = zero.add(this.glonassOrbit.getE());
        DerivativeStructure tDR = w.multiply(2.0).add(1.0).multiply(this.glonassOrbit.getDeltaTDot()).add(this.glonassOrbit.getDeltaT()).add(40544.0);
        DerivativeStructure n = tDR.divide(6.28318530717958).reciprocal();
        DerivativeStructure sma = this.computeSma(tDR, i, e);
        DerivativeStructure p = sma.multiply(e.multiply(e).negate().add(1.0));
        DerivativeStructure aeop = p.divide(6378136.0).reciprocal();
        DerivativeStructure aeop2 = aeop.multiply(aeop);
        DerivativeStructure lambda = this.computeLambda(dTpr, n, aeop2, i);
        DerivativeStructure pa = this.computePA(dTpr, n, aeop2, i);
        DerivativeStructure tanPAo2 = (DerivativeStructure)FastMath.tan((RealFieldElement)pa.divide(2.0));
        DerivativeStructure coef = tanPAo2.multiply((DerivativeStructure)FastMath.sqrt((RealFieldElement)e.negate().add(1.0).divide(e.add(1.0))));
        DerivativeStructure e0 = ((DerivativeStructure)FastMath.atan((RealFieldElement)coef)).multiply(2.0).negate();
        DerivativeStructure m1 = pa.add(e0).subtract(((DerivativeStructure)FastMath.sin((RealFieldElement)e0)).multiply(e));
        DerivativeStructure correction = dTpr.subtract(w.multiply(40544.0 + this.glonassOrbit.getDeltaT())).subtract(w.multiply(w).multiply(this.glonassOrbit.getDeltaTDot()));
        DerivativeStructure m = m1.add(n.multiply(correction));
        DerivativeStructure h = e.multiply((DerivativeStructure)FastMath.sin((RealFieldElement)pa));
        DerivativeStructure l = e.multiply((DerivativeStructure)FastMath.cos((RealFieldElement)pa));
        DerivativeStructure[] d1 = this.getParameterDifferentials(sma, i, h, l, m1);
        DerivativeStructure[] d2 = this.getParameterDifferentials(sma, i, h, l, m);
        DerivativeStructure smaCorr = sma.add(d2[0]).subtract(d1[0]);
        DerivativeStructure hCorr = h.add(d2[1]).subtract(d1[1]);
        DerivativeStructure lCorr = l.add(d2[2]).subtract(d1[2]);
        DerivativeStructure lambdaCorr = lambda.add(d2[3]).subtract(d1[3]);
        DerivativeStructure iCorr = i.add(d2[4]).subtract(d1[4]);
        DerivativeStructure mCorr = m.add(d2[5]).subtract(d1[5]);
        DerivativeStructure eCorr = (DerivativeStructure)FastMath.sqrt((RealFieldElement)hCorr.multiply(hCorr).add(lCorr.multiply(lCorr)));
        DerivativeStructure paCorr = eCorr.getValue() == 0.0 ? zero : (lCorr.getValue() == eCorr.getValue() ? zero.add(1.570796326794895) : (lCorr.getValue() == -eCorr.getValue() ? zero.add(-1.570796326794895) : (DerivativeStructure)FastMath.atan2((RealFieldElement)hCorr, (RealFieldElement)lCorr)));
        DerivativeStructure mk = mCorr.subtract(paCorr);
        DerivativeStructure ek = this.getEccentricAnomaly(mk, eCorr);
        DerivativeStructure vk = this.getTrueAnomaly(ek, eCorr);
        DerivativeStructure phik = vk.add(paCorr);
        DerivativeStructure pCorr = smaCorr.multiply(eCorr.multiply(eCorr).negate().add(1.0));
        DerivativeStructure rk = pCorr.divide(eCorr.multiply((DerivativeStructure)FastMath.cos((RealFieldElement)vk)).add(1.0));
        DerivativeStructure xk = ((DerivativeStructure)FastMath.cos((RealFieldElement)phik)).multiply(rk);
        DerivativeStructure yk = ((DerivativeStructure)FastMath.sin((RealFieldElement)phik)).multiply(rk);
        DerivativeStructure cosL = (DerivativeStructure)FastMath.cos((RealFieldElement)lambdaCorr);
        DerivativeStructure sinL = (DerivativeStructure)FastMath.sin((RealFieldElement)lambdaCorr);
        DerivativeStructure cosI = (DerivativeStructure)FastMath.cos((RealFieldElement)iCorr);
        DerivativeStructure sinI = (DerivativeStructure)FastMath.sin((RealFieldElement)iCorr);
        FieldVector3D positionwithDerivatives = new FieldVector3D((RealFieldElement)xk.multiply(cosL).subtract(yk.multiply(sinL).multiply(cosI)), (RealFieldElement)xk.multiply(sinL).add(yk.multiply(cosL).multiply(cosI)), (RealFieldElement)yk.multiply(sinI));
        return new PVCoordinates((FieldVector3D<DerivativeStructure>)positionwithDerivatives);
    }

    private DerivativeStructure getEccentricAnomaly(DerivativeStructure mk, DerivativeStructure e) {
        DerivativeStructure ek;
        double[] mlDerivatives = mk.getAllDerivatives();
        mlDerivatives[0] = MathUtils.normalizeAngle((double)mlDerivatives[0], (double)0.0);
        DerivativeStructure reducedM = mk.getFactory().build(mlDerivatives);
        if (FastMath.abs((double)reducedM.getValue()) < 0.16666666666666666) {
            ek = FastMath.abs((double)reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(e));
        } else if (reducedM.getValue() < 0.0) {
            DerivativeStructure w = reducedM.add(Math.PI);
            ek = reducedM.add(w.multiply(-A).divide(w.subtract(B)).subtract(Math.PI).subtract(reducedM).multiply(e));
        } else {
            DerivativeStructure minusW = reducedM.subtract(Math.PI);
            ek = reducedM.add(minusW.multiply(A).divide(minusW.add(B)).add(Math.PI).subtract(reducedM).multiply(e));
        }
        DerivativeStructure e1 = e.negate().add(1.0);
        boolean noCancellationRisk = e1.getValue() + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            DerivativeStructure fd;
            DerivativeStructure f;
            DerivativeStructure fdd = ek.sin().multiply(e);
            DerivativeStructure fddd = ek.cos().multiply(e);
            if (noCancellationRisk) {
                f = ek.subtract(fdd).subtract(reducedM);
                fd = fddd.subtract(1.0).negate();
            } else {
                f = this.eMeSinE(ek, e).subtract(reducedM);
                DerivativeStructure s = ek.multiply(0.5).sin();
                fd = s.multiply(s).multiply(e.multiply(2.0)).add(e1);
            }
            DerivativeStructure dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
            DerivativeStructure w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
            fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
            ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
        }
        ek = ek.add(mk.getValue() - reducedM.getValue());
        return ek;
    }

    private DerivativeStructure eMeSinE(DerivativeStructure E, DerivativeStructure ecc) {
        DerivativeStructure x = E.sin().multiply(ecc.negate().add(1.0));
        DerivativeStructure mE2 = E.negate().multiply(E);
        DerivativeStructure term = E;
        DerivativeStructure d = (DerivativeStructure)E.getField().getZero();
        DerivativeStructure x0 = d.add(Double.NaN);
        while (!Double.valueOf(x.getValue()).equals(x0.getValue())) {
            d = d.add(2.0);
            term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
            x0 = x;
            x = x.subtract(term);
        }
        return x;
    }

    private DerivativeStructure getTrueAnomaly(DerivativeStructure ek, DerivativeStructure ecc) {
        DerivativeStructure svk = ek.sin().multiply((DerivativeStructure)FastMath.sqrt((RealFieldElement)ecc.multiply(ecc).negate().add(1.0)));
        DerivativeStructure cvk = ek.cos().subtract(ecc);
        return svk.atan2(cvk);
    }

    private DerivativeStructure getdTpr(AbsoluteDate date) {
        GLONASSDate tEnd = new GLONASSDate(date);
        GLONASSDate tSta = new GLONASSDate(this.glonassOrbit.getDate());
        int n = tEnd.getDayNumber();
        int na = tSta.getDayNumber();
        int deltaN = na == 27 ? n - na - FastMath.round((float)((float)(n - na) / 1460.0f)) * 1460 : n - na - FastMath.round((float)((float)(n - na) / 1461.0f)) * 1461;
        DerivativeStructure ti = this.factory.variable(0, tEnd.getSecInDay());
        return ti.subtract(this.glonassOrbit.getTime()).add((double)(86400 * deltaN));
    }

    private DerivativeStructure computeSma(DerivativeStructure tDR, DerivativeStructure i, DerivativeStructure e) {
        DerivativeStructure zero = (DerivativeStructure)tDR.getField().getZero();
        if (Double.isNaN(tDR.getValue()) || Double.isNaN(i.getValue()) || Double.isNaN(e.getValue())) {
            return zero.add(Double.NaN);
        }
        DerivativeStructure sinI = (DerivativeStructure)FastMath.sin((RealFieldElement)i);
        DerivativeStructure sin2I = sinI.multiply(sinI);
        DerivativeStructure ome2 = e.multiply(e).negate().add(1.0);
        DerivativeStructure ome2Pow3o2 = ((DerivativeStructure)FastMath.sqrt((RealFieldElement)ome2)).multiply(ome2);
        DerivativeStructure pa = zero.add(this.glonassOrbit.getPa());
        DerivativeStructure cosPA = (DerivativeStructure)FastMath.cos((RealFieldElement)pa);
        DerivativeStructure opecosPA = e.multiply(cosPA).add(1.0);
        DerivativeStructure opecosPAPow2 = opecosPA.multiply(opecosPA);
        DerivativeStructure opecosPAPow3 = opecosPAPow2.multiply(opecosPA);
        DerivativeStructure tOCK = tDR;
        DerivativeStructure an = zero;
        DerivativeStructure anp1 = zero;
        boolean isLastStep = false;
        while (!isLastStep) {
            DerivativeStructure tOCKo2p = tOCK.divide(6.28318530717958);
            DerivativeStructure tOCKo2pPow2 = tOCKo2p.multiply(tOCKo2p);
            anp1 = (DerivativeStructure)FastMath.cbrt((RealFieldElement)tOCKo2pPow2.multiply(3.986004418E14));
            DerivativeStructure p = anp1.multiply(ome2);
            DerivativeStructure aeop = p.divide(6378136.0).reciprocal();
            DerivativeStructure aeop2 = aeop.multiply(aeop);
            DerivativeStructure term1 = aeop2.multiply(0.00108262575).multiply(1.5);
            DerivativeStructure term2 = sin2I.multiply(2.5).negate().add(2.0);
            DerivativeStructure term3 = ome2Pow3o2.divide(opecosPAPow2);
            DerivativeStructure term4 = opecosPAPow3.divide(ome2);
            tOCK = tDR.divide(term1.multiply(term2.multiply(term3).add(term4)).negate().add(1.0));
            if (FastMath.abs((double)anp1.subtract(an).getReal()) <= 0.01) {
                isLastStep = true;
            }
            an = anp1;
        }
        return an;
    }

    private DerivativeStructure computeLambda(DerivativeStructure dTpr, DerivativeStructure n, DerivativeStructure aeop2, DerivativeStructure i) {
        DerivativeStructure cosI = (DerivativeStructure)FastMath.cos((RealFieldElement)i);
        DerivativeStructure precession = aeop2.multiply(n).multiply(cosI).multiply(0.0016239386250000002);
        return dTpr.multiply(precession.add(7.292115E-5)).negate().add(this.glonassOrbit.getLambda());
    }

    private DerivativeStructure computePA(DerivativeStructure dTpr, DerivativeStructure n, DerivativeStructure aeop2, DerivativeStructure i) {
        DerivativeStructure cosI = (DerivativeStructure)FastMath.cos((RealFieldElement)i);
        DerivativeStructure cos2I = cosI.multiply(cosI);
        DerivativeStructure precession = aeop2.multiply(n).multiply(cos2I.multiply(5.0).negate().add(1.0)).multiply(8.119693125000001E-4);
        return dTpr.multiply(precession).negate().add(this.glonassOrbit.getPa());
    }

    private DerivativeStructure[] getParameterDifferentials(DerivativeStructure a, DerivativeStructure i, DerivativeStructure h, DerivativeStructure l, DerivativeStructure m) {
        DerivativeStructure aeoa = a.divide(6378136.0).reciprocal();
        DerivativeStructure aeoa2 = aeoa.multiply(aeoa);
        DerivativeStructure b = aeoa2.multiply(0.0016239386250000002);
        DerivativeStructure cosI = (DerivativeStructure)FastMath.cos((RealFieldElement)i);
        DerivativeStructure sinI = (DerivativeStructure)FastMath.sin((RealFieldElement)i);
        DerivativeStructure cosI2 = cosI.multiply(cosI);
        DerivativeStructure sinI2 = sinI.multiply(sinI);
        DerivativeStructure cosLk = (DerivativeStructure)FastMath.cos((RealFieldElement)m);
        DerivativeStructure sinLk = (DerivativeStructure)FastMath.sin((RealFieldElement)m);
        DerivativeStructure cos2Lk = (DerivativeStructure)FastMath.cos((RealFieldElement)m.multiply(2.0));
        DerivativeStructure sin2Lk = (DerivativeStructure)FastMath.sin((RealFieldElement)m.multiply(2.0));
        DerivativeStructure cos3Lk = (DerivativeStructure)FastMath.cos((RealFieldElement)m.multiply(3.0));
        DerivativeStructure sin3Lk = (DerivativeStructure)FastMath.sin((RealFieldElement)m.multiply(3.0));
        DerivativeStructure cos4Lk = (DerivativeStructure)FastMath.cos((RealFieldElement)m.multiply(4.0));
        DerivativeStructure sin4Lk = (DerivativeStructure)FastMath.sin((RealFieldElement)m.multiply(4.0));
        DerivativeStructure hCosLk = h.multiply(cosLk);
        DerivativeStructure hSinLk = h.multiply(sinLk);
        DerivativeStructure lCosLk = l.multiply(cosLk);
        DerivativeStructure lSinLk = l.multiply(sinLk);
        DerivativeStructure hCos2Lk = h.multiply(cos2Lk);
        DerivativeStructure hSin2Lk = h.multiply(sin2Lk);
        DerivativeStructure lCos2Lk = l.multiply(cos2Lk);
        DerivativeStructure lSin2Lk = l.multiply(sin2Lk);
        DerivativeStructure hCos3Lk = h.multiply(cos3Lk);
        DerivativeStructure hSin3Lk = h.multiply(sin3Lk);
        DerivativeStructure lCos3Lk = l.multiply(cos3Lk);
        DerivativeStructure lSin3Lk = l.multiply(sin3Lk);
        DerivativeStructure hCos4Lk = h.multiply(cos4Lk);
        DerivativeStructure hSin4Lk = h.multiply(sin4Lk);
        DerivativeStructure lCos4Lk = l.multiply(cos4Lk);
        DerivativeStructure lSin4Lk = l.multiply(sin4Lk);
        DerivativeStructure om3o2xSinI2 = sinI2.multiply(1.5).negate().add(1.0);
        DerivativeStructure dakT1 = b.multiply(2.0).multiply(om3o2xSinI2).multiply(lCosLk.add(hSinLk));
        DerivativeStructure dakT2 = b.multiply(sinI2).multiply(hSinLk.multiply(0.5).subtract(lCosLk.multiply(0.5)).add(cos2Lk).add(lCos3Lk.multiply(3.5)).add(hSin3Lk.multiply(3.5)));
        DerivativeStructure dak = dakT1.add(dakT2);
        DerivativeStructure dhkT1 = b.multiply(om3o2xSinI2).multiply(sinLk.add(lSin2Lk.multiply(1.5)).subtract(hCos2Lk.multiply(1.5)));
        DerivativeStructure dhkT2 = b.multiply(sinI2).multiply(0.25).multiply(sinLk.subtract(sin3Lk.multiply(2.3333333333333335)).add(lSin2Lk.multiply(5.0)).subtract(lSin4Lk.multiply(8.5)).add(hCos4Lk.multiply(8.5)).add(hCos2Lk));
        DerivativeStructure dhkT3 = lSin2Lk.multiply(cosI2).multiply(b).multiply(0.5).negate();
        DerivativeStructure dhk = dhkT1.subtract(dhkT2).add(dhkT3);
        DerivativeStructure dlkT1 = b.multiply(om3o2xSinI2).multiply(cosLk.add(lCos2Lk.multiply(1.5)).add(hSin2Lk.multiply(1.5)));
        DerivativeStructure dlkT2 = b.multiply(sinI2).multiply(0.25).multiply(cosLk.negate().subtract(cos3Lk.multiply(2.3333333333333335)).subtract(hSin2Lk.multiply(5.0)).subtract(lCos4Lk.multiply(8.5)).subtract(hSin4Lk.multiply(8.5)).add(lCos2Lk));
        DerivativeStructure dlkT3 = hSin2Lk.multiply(cosI2).multiply(b).multiply(0.5);
        DerivativeStructure dlk = dlkT1.subtract(dlkT2).add(dlkT3);
        DerivativeStructure dokT1 = b.negate().multiply(cosI);
        DerivativeStructure dokT2 = lSinLk.multiply(3.5).subtract(hCosLk.multiply(2.5)).subtract(sin2Lk.multiply(0.5)).subtract(lSin3Lk.multiply(1.1666666666666667)).add(hCos3Lk.multiply(1.1666666666666667));
        DerivativeStructure dok = dokT1.multiply(dokT2);
        DerivativeStructure dik = b.multiply(sinI).multiply(cosI).multiply(0.5).multiply(lCosLk.negate().add(hSinLk).add(cos2Lk).add(lCos3Lk.multiply(2.3333333333333335)).add(hSin3Lk.multiply(2.3333333333333335)));
        DerivativeStructure dLkT1 = b.multiply(2.0).multiply(om3o2xSinI2).multiply(lSinLk.multiply(1.75).subtract(hCosLk.multiply(1.75)));
        DerivativeStructure dLkT2 = b.multiply(sinI2).multiply(3.0).multiply(hCosLk.multiply(0.2916666666666667).negate().subtract(lSinLk.multiply(0.2916666666666667)).subtract(hCos3Lk.multiply(0.6805555555555556)).add(lSin3Lk.multiply(0.6805555555555556)).add(sin2Lk.multiply(0.25)));
        DerivativeStructure dLkT3 = b.multiply(cosI2).multiply(lSinLk.multiply(3.5).subtract(hCosLk.multiply(2.5)).subtract(sin2Lk.multiply(0.5)).subtract(lSin3Lk.multiply(1.1666666666666667)).add(hCos3Lk.multiply(1.1666666666666667)));
        DerivativeStructure dLk = dLkT1.add(dLkT2).add(dLkT3);
        DerivativeStructure[] differentials = (DerivativeStructure[])MathArrays.buildArray((Field)a.getField(), (int)6);
        differentials[0] = dak.multiply(a);
        differentials[1] = dhk;
        differentials[2] = dlk;
        differentials[3] = dok;
        differentials[4] = dik;
        differentials[5] = dLk;
        return differentials;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    public static double getMU() {
        return 3.986004418E14;
    }

    public GLONASSOrbitalElements getGLONASSOrbitalElements() {
        return this.glonassOrbit;
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, 3.986004418E14);
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }

    public static class Builder {
        private final GLONASSOrbitalElements orbit;
        private AttitudeProvider attitudeProvider = Propagator.DEFAULT_LAW;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(GLONASSOrbitalElements glonassOrbElt) {
            this.orbit = glonassOrbElt;
            this.eci = FramesFactory.getEME2000();
            this.ecef = FramesFactory.getITRF(IERSConventions.IERS_2010, true);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public GLONASSAnalyticalPropagator build() {
            return new GLONASSAnalyticalPropagator(this);
        }
    }
}

