/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.Collection;
import java.util.List;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public interface Propagator
extends PVCoordinatesProvider {
    public static final double DEFAULT_MASS = 1000.0;
    public static final AttitudeProvider DEFAULT_LAW = InertialProvider.EME2000_ALIGNED;
    public static final int SLAVE_MODE = 0;
    public static final int MASTER_MODE = 1;
    public static final int EPHEMERIS_GENERATION_MODE = 2;

    public int getMode();

    public void setSlaveMode();

    public void setMasterMode(double var1, OrekitFixedStepHandler var3);

    public void setMasterMode(OrekitStepHandler var1);

    public void setEphemerisMode();

    public void setEphemerisMode(OrekitStepHandler var1);

    public BoundedPropagator getGeneratedEphemeris() throws IllegalStateException;

    public SpacecraftState getInitialState();

    public void resetInitialState(SpacecraftState var1);

    public void addAdditionalStateProvider(AdditionalStateProvider var1);

    public List<AdditionalStateProvider> getAdditionalStateProviders();

    public boolean isAdditionalStateManaged(String var1);

    public String[] getManagedAdditionalStates();

    public <T extends EventDetector> void addEventDetector(T var1);

    public Collection<EventDetector> getEventsDetectors();

    public void clearEventsDetectors();

    public AttitudeProvider getAttitudeProvider();

    public void setAttitudeProvider(AttitudeProvider var1);

    public Frame getFrame();

    public SpacecraftState propagate(AbsoluteDate var1);

    public SpacecraftState propagate(AbsoluteDate var1, AbsoluteDate var2);
}

