/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.Pair;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.GPSAlmanac;

public class YUMAParser
implements DataLoader {
    private static final String SOURCE = "YUMA";
    private static final String[] KEY = new String[]{"id", "health", "eccentricity", "time", "orbital", "rate", "sqrt", "right", "argument", "mean", "af0", "af1", "week"};
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.alm$";
    private final String supportedNames;
    private final List<GPSAlmanac> almanacs;
    private final List<Integer> prnList;

    public YUMAParser(String supportedNames) {
        this.supportedNames = supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames;
        this.almanacs = new ArrayList<GPSAlmanac>();
        this.prnList = new ArrayList<Integer>();
    }

    public void loadData() {
        DataProvidersManager.getInstance().feed(this.supportedNames, this);
        if (this.almanacs.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_YUMA_ALMANAC_AVAILABLE, new Object[0]);
        }
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.almanacs.clear();
        this.prnList.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        try {
            ArrayList<Pair<String, String>> entries = new ArrayList<Pair<String, String>>(KEY.length);
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.trim().split(":");
                if (token.length == 2) {
                    entries.add((Pair<String, String>)new Pair((Object)token[0].trim(), (Object)token[1].trim()));
                }
                if (entries.size() == KEY.length) {
                    GPSAlmanac almanac = this.getAlmanac(entries, name);
                    this.almanacs.add(almanac);
                    this.prnList.add(almanac.getPRN());
                    entries.clear();
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.almanacs.isEmpty();
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public List<GPSAlmanac> getAlmanacs() {
        return this.almanacs;
    }

    public List<Integer> getPRNNumbers() {
        return this.prnList;
    }

    private GPSAlmanac getAlmanac(List<Pair<String, String>> entries, String name) {
        try {
            int prn = 0;
            int health = 0;
            int week = 0;
            double ecc = 0.0;
            double toa = 0.0;
            double inc = 0.0;
            double dom = 0.0;
            double sqa = 0.0;
            double om0 = 0.0;
            double aop = 0.0;
            double anom = 0.0;
            double af0 = 0.0;
            double af1 = 0.0;
            boolean[] checks = new boolean[KEY.length];
            for (Pair<String, String> entry : entries) {
                String lowerCaseKey = ((String)entry.getKey()).toLowerCase(Locale.US);
                if (lowerCaseKey.startsWith(KEY[0])) {
                    prn = Integer.parseInt((String)entry.getValue());
                    checks[0] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[1])) {
                    health = Integer.parseInt((String)entry.getValue());
                    checks[1] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[2])) {
                    ecc = Double.parseDouble((String)entry.getValue());
                    checks[2] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[3])) {
                    toa = Double.parseDouble((String)entry.getValue());
                    checks[3] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[4])) {
                    inc = Double.parseDouble((String)entry.getValue());
                    checks[4] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[5])) {
                    dom = Double.parseDouble((String)entry.getValue());
                    checks[5] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[6])) {
                    sqa = Double.parseDouble((String)entry.getValue());
                    checks[6] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[7])) {
                    om0 = Double.parseDouble((String)entry.getValue());
                    checks[7] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[8])) {
                    aop = Double.parseDouble((String)entry.getValue());
                    checks[8] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[9])) {
                    anom = Double.parseDouble((String)entry.getValue());
                    checks[9] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[10])) {
                    af0 = Double.parseDouble((String)entry.getValue());
                    checks[10] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[11])) {
                    af1 = Double.parseDouble((String)entry.getValue());
                    checks[11] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[12])) {
                    week = Integer.parseInt((String)entry.getValue());
                    checks[12] = true;
                    continue;
                }
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
            }
            if (this.readOK(checks)) {
                return new GPSAlmanac(SOURCE, prn, -1, week, toa, sqa, ecc, inc, om0, dom, aop, anom, af0, af1, health, -1, -1);
            }
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    private boolean readOK(boolean[] checks) {
        for (boolean check : checks) {
            if (check) continue;
            return false;
        }
        return true;
    }
}

