/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import org.hipparchus.util.FastMath;
import org.orekit.utils.ParameterDriver;

public class ObservableSatellite {
    public static final String CLOCK_OFFSET_PREFIX = "clock-offset-satellite-";
    private static final double CLOCK_OFFSET_SCALE = FastMath.scalb((double)1.0, (int)-10);
    private final int propagatorIndex;
    private final ParameterDriver clockOffsetDriver;

    public ObservableSatellite(int propagatorIndex) {
        this.propagatorIndex = propagatorIndex;
        this.clockOffsetDriver = new ParameterDriver(CLOCK_OFFSET_PREFIX + propagatorIndex, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public int getPropagatorIndex() {
        return this.propagatorIndex;
    }

    public ParameterDriver getClockOffsetDriver() {
        return this.clockOffsetDriver;
    }
}

