/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.hipparchus.ode.nonstiff.ButcherArrayProvider;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;
import org.hipparchus.util.FastMath;

public abstract class EmbeddedRungeKuttaIntegrator
extends AdaptiveStepsizeIntegrator
implements ButcherArrayProvider {
    private final int fsal;
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected EmbeddedRungeKuttaIntegrator(String name, int fsal, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    protected EmbeddedRungeKuttaIntegrator(String name, int fsal, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    protected abstract RungeKuttaStateInterpolator createInterpolator(boolean var1, double[][] var2, ODEStateAndDerivative var3, ODEStateAndDerivative var4, EquationsMapper var5);

    public abstract int getOrder();

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        int stages = this.c.length + 1;
        double[][] yDotK = new double[stages][];
        double[] yTmp = new double[equations.getMapper().getTotalDimension()];
        double hNew = 0.0;
        boolean firstTime = true;
        this.setIsLastStep(false);
        do {
            boolean filteredNextIsLast;
            double error = 10.0;
            while (error >= 1.0) {
                double[] y = this.getStepStart().getCompleteState();
                yDotK[0] = this.getStepStart().getCompleteDerivative();
                if (firstTime) {
                    int i;
                    double[] scale = new double[this.mainSetDimension];
                    if (this.vecAbsoluteTolerance == null) {
                        for (i = 0; i < scale.length; ++i) {
                            scale[i] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * FastMath.abs((double)y[i]);
                        }
                    } else {
                        for (i = 0; i < scale.length; ++i) {
                            scale[i] = this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * FastMath.abs((double)y[i]);
                        }
                    }
                    hNew = this.initializeStep(forward, this.getOrder(), scale, this.getStepStart(), equations.getMapper());
                    firstTime = false;
                }
                this.setStepSize(hNew);
                if (forward) {
                    if (this.getStepStart().getTime() + this.getStepSize() >= finalTime) {
                        this.setStepSize(finalTime - this.getStepStart().getTime());
                    }
                } else if (this.getStepStart().getTime() + this.getStepSize() <= finalTime) {
                    this.setStepSize(finalTime - this.getStepStart().getTime());
                }
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y.length; ++j) {
                        double sum = this.a[k - 1][0] * yDotK[0][j];
                        for (int l = 1; l < k; ++l) {
                            sum += this.a[k - 1][l] * yDotK[l][j];
                        }
                        yTmp[j] = y[j] + this.getStepSize() * sum;
                    }
                    yDotK[k] = this.computeDerivatives(this.getStepStart().getTime() + this.c[k - 1] * this.getStepSize(), yTmp);
                }
                for (int j = 0; j < y.length; ++j) {
                    double sum = this.b[0] * yDotK[0][j];
                    for (int l = 1; l < stages; ++l) {
                        sum += this.b[l] * yDotK[l][j];
                    }
                    yTmp[j] = y[j] + this.getStepSize() * sum;
                }
                error = this.estimateError(yDotK, y, yTmp, this.getStepSize());
                if (Double.isNaN(error)) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{this.getStepStart().getTime() + this.getStepSize()});
                }
                if (!(error >= 1.0)) continue;
                double factor = FastMath.min((double)this.maxGrowth, (double)FastMath.max((double)this.minReduction, (double)(this.safety * FastMath.pow((double)error, (double)this.exp))));
                hNew = this.filterStep(this.getStepSize() * factor, forward, false);
            }
            double stepEnd = this.getStepStart().getTime() + this.getStepSize();
            double[] yDotTmp = this.fsal >= 0 ? yDotK[this.fsal] : this.computeDerivatives(stepEnd, yTmp);
            ODEStateAndDerivative stateTmp = equations.getMapper().mapStateAndDerivative(stepEnd, yTmp, yDotTmp);
            this.setStepStart(this.acceptStep(this.createInterpolator(forward, yDotK, this.getStepStart(), stateTmp, equations.getMapper()), finalTime));
            if (this.isLastStep()) continue;
            double factor = FastMath.min((double)this.maxGrowth, (double)FastMath.max((double)this.minReduction, (double)(this.safety * FastMath.pow((double)error, (double)this.exp))));
            double scaledH = this.getStepSize() * factor;
            double nextT = this.getStepStart().getTime() + scaledH;
            boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
            hNew = this.filterStep(scaledH, forward, nextIsLast);
            double filteredNextT = this.getStepStart().getTime() + hNew;
            boolean bl = forward ? filteredNextT >= finalTime : (filteredNextIsLast = filteredNextT <= finalTime);
            if (!filteredNextIsLast) continue;
            hNew = finalTime - this.getStepStart().getTime();
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.resetInternalState();
        return finalState;
    }

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    protected abstract double estimateError(double[][] var1, double[] var2, double[] var3, double var4);
}

