/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.util.MathArrays;

public class FieldODEStateAndDerivative<T extends RealFieldElement<T>>
extends FieldODEState<T> {
    private final T[] primaryDerivative;
    private final T[][] secondaryDerivative;

    public FieldODEStateAndDerivative(T time, T[] primaryState, T[] primaryDerivative) {
        this((RealFieldElement)time, (RealFieldElement[])primaryState, (RealFieldElement[])primaryDerivative, null, null);
    }

    public FieldODEStateAndDerivative(T time, T[] primaryState, T[] primaryDerivative, T[][] secondaryState, T[][] secondaryDerivative) {
        super(time, primaryState, secondaryState);
        this.primaryDerivative = (RealFieldElement[])primaryDerivative.clone();
        this.secondaryDerivative = this.copy((RealFieldElement[][])secondaryDerivative);
    }

    public T[] getPrimaryDerivative() {
        return (RealFieldElement[])this.primaryDerivative.clone();
    }

    public T[] getSecondaryDerivative(int index) {
        return index == 0 ? (RealFieldElement[])this.primaryDerivative.clone() : (RealFieldElement[])this.secondaryDerivative[index - 1].clone();
    }

    public T[] getCompleteDerivative() {
        RealFieldElement[] completeDerivative = (RealFieldElement[])MathArrays.buildArray((Field)this.getTime().getField(), (int)this.getCompleteStateDimension());
        System.arraycopy(this.primaryDerivative, 0, completeDerivative, 0, this.primaryDerivative.length);
        int offset = this.primaryDerivative.length;
        if (this.secondaryDerivative != null) {
            for (int index = 0; index < this.secondaryDerivative.length; ++index) {
                System.arraycopy(this.secondaryDerivative[index], 0, completeDerivative, offset, this.secondaryDerivative[index].length);
                offset += this.secondaryDerivative[index].length;
            }
        }
        return completeDerivative;
    }
}

