/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.RealFieldUnivariateFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldPolynomialFunction<T extends RealFieldElement<T>>
implements RealFieldUnivariateFunction<T> {
    private final T[] coefficients;

    public FieldPolynomialFunction(T[] c) throws MathIllegalArgumentException, NullArgumentException {
        int n;
        MathUtils.checkNotNull(c);
        if (n == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY, new Object[0]);
        }
        for (n = c.length; n > 1 && c[n - 1].getReal() == 0.0; --n) {
        }
        this.coefficients = (RealFieldElement[])MathArrays.buildArray(c[0].getField(), n);
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    @Override
    public T value(double x) {
        return (T)FieldPolynomialFunction.evaluate(this.coefficients, (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(x)));
    }

    @Override
    public T value(T x) {
        return (T)FieldPolynomialFunction.evaluate(this.coefficients, x);
    }

    public Field<T> getField() {
        return this.coefficients[0].getField();
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public T[] getCoefficients() {
        return (RealFieldElement[])this.coefficients.clone();
    }

    protected static <T extends RealFieldElement<T>> T evaluate(T[] coefficients, T argument) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(coefficients);
        int n = coefficients.length;
        if (n == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY, new Object[0]);
        }
        Object result = coefficients[n - 1];
        for (int j = n - 2; j >= 0; --j) {
            result = (RealFieldElement)((RealFieldElement)argument.multiply(result)).add(coefficients[j]);
        }
        return result;
    }

    public FieldPolynomialFunction<T> add(FieldPolynomialFunction<T> p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        RealFieldElement[] newCoefficients = (RealFieldElement[])MathArrays.buildArray(this.getField(), highLength);
        for (int i = 0; i < lowLength; ++i) {
            newCoefficients[i] = (RealFieldElement)this.coefficients[i].add(p.coefficients[i]);
        }
        System.arraycopy(this.coefficients.length < p.coefficients.length ? p.coefficients : this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        return new FieldPolynomialFunction(newCoefficients);
    }

    public FieldPolynomialFunction<T> subtract(FieldPolynomialFunction<T> p) {
        int i;
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        RealFieldElement[] newCoefficients = (RealFieldElement[])MathArrays.buildArray(this.getField(), highLength);
        for (i = 0; i < lowLength; ++i) {
            newCoefficients[i] = (RealFieldElement)this.coefficients[i].subtract(p.coefficients[i]);
        }
        if (this.coefficients.length < p.coefficients.length) {
            for (i = lowLength; i < highLength; ++i) {
                newCoefficients[i] = (RealFieldElement)p.coefficients[i].negate();
            }
        } else {
            System.arraycopy(this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        }
        return new FieldPolynomialFunction(newCoefficients);
    }

    public FieldPolynomialFunction<T> negate() {
        RealFieldElement[] newCoefficients = (RealFieldElement[])MathArrays.buildArray(this.getField(), this.coefficients.length);
        for (int i = 0; i < this.coefficients.length; ++i) {
            newCoefficients[i] = (RealFieldElement)this.coefficients[i].negate();
        }
        return new FieldPolynomialFunction(newCoefficients);
    }

    public FieldPolynomialFunction<T> multiply(FieldPolynomialFunction<T> p) {
        Field<T> field = this.getField();
        RealFieldElement[] newCoefficients = (RealFieldElement[])MathArrays.buildArray(field, this.coefficients.length + p.coefficients.length - 1);
        for (int i = 0; i < newCoefficients.length; ++i) {
            newCoefficients[i] = (RealFieldElement)field.getZero();
            for (int j = FastMath.max(0, i + 1 - p.coefficients.length); j < FastMath.min(this.coefficients.length, i + 1); ++j) {
                newCoefficients[i] = (RealFieldElement)newCoefficients[i].add(this.coefficients[j].multiply(p.coefficients[i - j]));
            }
        }
        return new FieldPolynomialFunction(newCoefficients);
    }

    protected static <T extends RealFieldElement<T>> T[] differentiate(T[] coefficients) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(coefficients);
        int n = coefficients.length;
        if (n == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY, new Object[0]);
        }
        Field field = coefficients[0].getField();
        RealFieldElement[] result = (RealFieldElement[])MathArrays.buildArray(field, FastMath.max(1, n - 1));
        if (n == 1) {
            result[0] = (RealFieldElement)field.getZero();
        } else {
            for (int i = n - 1; i > 0; --i) {
                result[i - 1] = (RealFieldElement)coefficients[i].multiply((int)i);
            }
        }
        return result;
    }

    public FieldPolynomialFunction<T> antiDerivative() {
        Field<T> field = this.getField();
        int d = this.degree();
        RealFieldElement[] anti = (RealFieldElement[])MathArrays.buildArray(field, d + 2);
        anti[0] = (RealFieldElement)field.getZero();
        for (int i = 1; i <= d + 1; ++i) {
            anti[i] = (RealFieldElement)this.coefficients[i - 1].multiply(1.0 / (double)i);
        }
        return new FieldPolynomialFunction(anti);
    }

    public T integrate(double lower, double upper) {
        RealFieldElement zero = (RealFieldElement)this.getField().getZero();
        return (T)this.integrate((RealFieldElement)zero.add(lower), (RealFieldElement)zero.add(upper));
    }

    public T integrate(T lower, T upper) {
        if (Double.isInfinite(lower.getReal()) || Double.isInfinite(upper.getReal())) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INFINITE_BOUND, new Object[0]);
        }
        if (lower.getReal() > upper.getReal()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, new Object[0]);
        }
        FieldPolynomialFunction<T> anti = this.antiDerivative();
        return (T)((RealFieldElement)anti.value(upper).subtract(anti.value(lower)));
    }

    public FieldPolynomialFunction<T> polynomialDerivative() {
        return new FieldPolynomialFunction(FieldPolynomialFunction.differentiate(this.coefficients));
    }
}

