/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;

public abstract class BaseRuleFactory<T extends Number> {
    private final SortedMap<Integer, Pair<T[], T[]>> pointsAndWeights = new TreeMap<Integer, Pair<T[], T[]>>();
    private final SortedMap<Integer, Pair<double[], double[]>> pointsAndWeightsDouble = new TreeMap<Integer, Pair<double[], double[]>>();

    public Pair<double[], double[]> getRule(int numberOfPoints) throws MathIllegalArgumentException {
        if (numberOfPoints <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, numberOfPoints);
        }
        Pair<double[], double[]> cached = (Pair<double[], double[]>)this.pointsAndWeightsDouble.get(numberOfPoints);
        if (cached == null) {
            Pair<T[], T[]> rule = this.getRuleInternal(numberOfPoints);
            cached = BaseRuleFactory.convertToDouble(rule);
            this.pointsAndWeightsDouble.put(numberOfPoints, cached);
        }
        return new Pair<Object, Object>(((double[])cached.getFirst()).clone(), cached.getSecond().clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<T[], T[]> getRuleInternal(int numberOfPoints) throws MathIllegalArgumentException {
        SortedMap<Integer, Pair<T[], T[]>> sortedMap = this.pointsAndWeights;
        synchronized (sortedMap) {
            Pair rule = (Pair)this.pointsAndWeights.get(numberOfPoints);
            if (rule == null) {
                this.addRule(this.computeRule(numberOfPoints));
                return this.getRuleInternal(numberOfPoints);
            }
            return rule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRule(Pair<T[], T[]> rule) throws MathIllegalArgumentException {
        MathUtils.checkDimension(((Number[])rule.getFirst()).length, ((Number[])rule.getSecond()).length);
        SortedMap<Integer, Pair<T[], T[]>> sortedMap = this.pointsAndWeights;
        synchronized (sortedMap) {
            this.pointsAndWeights.put(((Number[])rule.getFirst()).length, rule);
        }
    }

    protected abstract Pair<T[], T[]> computeRule(int var1) throws MathIllegalArgumentException;

    private static <T extends Number> Pair<double[], double[]> convertToDouble(Pair<T[], T[]> rule) {
        Number[] pT = (Number[])rule.getFirst();
        Number[] wT = (Number[])rule.getSecond();
        int len = pT.length;
        double[] pD = new double[len];
        double[] wD = new double[len];
        for (int i = 0; i < len; ++i) {
            pD[i] = pT[i].doubleValue();
            wD[i] = wT[i].doubleValue();
        }
        return new Pair<double[], double[]>(pD, wD);
    }
}

