/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class TCGScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double LG_RATE = 6.969290134E-10;
    private static final AbsoluteDate REFERENCE_DATE = new AbsoluteDate(1977, 1, 1, (TimeScale)TimeScalesFactory.getTAI());
    private static final double TT_OFFSET = TimeScalesFactory.getTT().offsetFromTAI(REFERENCE_DATE);

    TCGScale() {
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return TT_OFFSET + 6.969290134E-10 * date.durationFrom(REFERENCE_DATE);
    }

    @Override
    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)((RealFieldElement)date.durationFrom(REFERENCE_DATE).multiply(6.969290134E-10)).add(TT_OFFSET));
    }

    @Override
    public String getName() {
        return "TCG";
    }

    public String toString() {
        return this.getName();
    }
}

