/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldCjSjCoefficient;

public class FieldGHmsjPolynomials<T extends RealFieldElement<T>> {
    private final FieldCjSjCoefficient<T> cjsjKH;
    private final FieldCjSjCoefficient<T> cjsjAB;
    private int I;
    private final T zero;

    public FieldGHmsjPolynomials(T k, T h, T alpha, T beta, int retroFactor, Field<T> field) {
        this.zero = (RealFieldElement)field.getZero();
        this.cjsjKH = new FieldCjSjCoefficient<T>(k, h, field);
        this.cjsjAB = new FieldCjSjCoefficient<T>(alpha, beta, field);
        this.I = retroFactor;
    }

    public T getGmsj(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object gms = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            gms = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.sgn(s - j))).multiply(this.I));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            gms = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getCj(sMim))).add(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m)));
        }
        return gms;
    }

    public T getHmsj(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object hms = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            hms = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            hms = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j)));
        }
        return hms;
    }

    public T getdGmsdk(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdk = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdk = (RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract(((RealFieldElement)((RealFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdk = (RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getCj(sMim))).add(((RealFieldElement)((RealFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - m))).multiply(this.sgn(s - j)));
        }
        return dGmsdk;
    }

    public T getdGmsdh(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdh = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdh = (RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract(((RealFieldElement)((RealFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdh = (RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getCj(sMim))).add(((RealFieldElement)((RealFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - m))).multiply(this.sgn(s - j)));
        }
        return dGmsdh;
    }

    public T getdGmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdAl = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdAl = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDk(mMis))).subtract(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDk(mMis))).multiply(this.I)).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdAl = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDk(sMim))).add(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDk(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m)));
        }
        return dGmsdAl;
    }

    public T getdGmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdBe = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdBe = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDh(mMis))).subtract(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDh(mMis))).multiply(this.I)).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdBe = (RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDh(sMim))).add(((RealFieldElement)((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDh(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m)));
        }
        return dGmsdBe;
    }

    public T getdHmsdk(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdk = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdk = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add(((RealFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdk = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add(((RealFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j)));
        }
        return dHmsdk;
    }

    public T getdHmsdh(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdh = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdh = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add(((RealFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdh = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add(((RealFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j)));
        }
        return dHmsdh;
    }

    public T getdHmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdAl = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdAl = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDk(mMis))).multiply(this.I)).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDk(mMis))).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdAl = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDk(sMim))).multiply(-this.sgn(s - m))).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDk(sMim))).multiply(this.sgn(s - j)));
        }
        return dHmsdAl;
    }

    public T getdHmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdBe = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdBe = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDh(mMis))).multiply(this.I)).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDh(mMis))).multiply(this.sgn(s - j)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdBe = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDh(sMim))).multiply(-this.sgn(s - m))).add(((RealFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDh(sMim))).multiply(this.sgn(s - j)));
        }
        return dHmsdBe;
    }

    private int sgn(int i) {
        return i < 0 ? -1 : 1;
    }
}

