/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;

public interface DSSTForceModel {
    public List<ShortPeriodTerms> initialize(AuxiliaryElements var1, PropagationType var2, double[] var3);

    public <T extends RealFieldElement<T>> List<FieldShortPeriodTerms<T>> initialize(FieldAuxiliaryElements<T> var1, PropagationType var2, T[] var3);

    default public double[] getParameters() {
        ParameterDriver[] drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.length];
        for (int i = 0; i < drivers.length; ++i) {
            parameters[i] = drivers[i].getValue();
        }
        return parameters;
    }

    default public <T extends RealFieldElement<T>> T[] getParameters(Field<T> field) {
        ParameterDriver[] drivers = this.getParametersDrivers();
        RealFieldElement[] parameters = (RealFieldElement[])MathArrays.buildArray(field, (int)drivers.length);
        for (int i = 0; i < drivers.length; ++i) {
            parameters[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(drivers[i].getValue());
        }
        return parameters;
    }

    public double[] getMeanElementRate(SpacecraftState var1, AuxiliaryElements var2, double[] var3);

    public <T extends RealFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> var1, FieldAuxiliaryElements<T> var2, T[] var3);

    public EventDetector[] getEventsDetectors();

    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> var1);

    public void registerAttitudeProvider(AttitudeProvider var1);

    public void updateShortPeriodTerms(double[] var1, SpacecraftState ... var2);

    public <T extends RealFieldElement<T>> void updateShortPeriodTerms(T[] var1, FieldSpacecraftState<T> ... var2);

    public ParameterDriver[] getParametersDrivers();
}

