/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldTransform<T extends RealFieldElement<T>>
implements TimeStamped,
TimeShiftable<FieldTransform<T>> {
    private final FieldAbsoluteDate<T> date;
    private final AbsoluteDate aDate;
    private final FieldPVCoordinates<T> cartesian;
    private final FieldAngularCoordinates<T> angular;

    private FieldTransform(FieldAbsoluteDate<T> date, AbsoluteDate aDate, FieldPVCoordinates<T> cartesian, FieldAngularCoordinates<T> angular) {
        this.date = date;
        this.aDate = aDate;
        this.cartesian = cartesian;
        this.angular = angular;
    }

    public FieldTransform(Field<T> field, Transform transform) {
        this(new FieldAbsoluteDate<T>(field, transform.getDate()), transform.getDate(), new FieldPVCoordinates<Field<T>>(field, transform.getCartesian()), new FieldAngularCoordinates<T>(field, transform.getAngular()));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldVector3D<T> translation) {
        this(date, date.toAbsoluteDate(), new FieldPVCoordinates<T>(translation, FieldVector3D.getZero(date.getField()), FieldVector3D.getZero(date.getField())), FieldAngularCoordinates.getIdentity(date.getField()));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldRotation<T> rotation) {
        this(date, date.toAbsoluteDate(), FieldPVCoordinates.getZero(date.getField()), new FieldAngularCoordinates<T>(rotation, FieldVector3D.getZero(date.getField()), FieldVector3D.getZero(date.getField())));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldVector3D<T> translation, FieldVector3D<T> velocity) {
        this(date, new FieldPVCoordinates<T>(translation, velocity, FieldVector3D.getZero(date.getField())));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldVector3D<T> translation, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        this(date, new FieldPVCoordinates<T>(translation, velocity, acceleration));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> cartesian) {
        this(date, date.toAbsoluteDate(), cartesian, FieldAngularCoordinates.getIdentity(date.getField()));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        this(date, new FieldAngularCoordinates<T>(rotation, rotationRate, FieldVector3D.getZero(date.getField())));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this(date, new FieldAngularCoordinates<T>(rotation, rotationRate, rotationAcceleration));
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldAngularCoordinates<T> angular) {
        this(date, date.toAbsoluteDate(), FieldPVCoordinates.getZero(date.getField()), angular);
    }

    public FieldTransform(FieldAbsoluteDate<T> date, FieldTransform<T> first, FieldTransform<T> second) {
        this(date, date.toAbsoluteDate(), new FieldPVCoordinates<T>(FieldTransform.compositeTranslation(first, second), FieldTransform.compositeVelocity(first, second), FieldTransform.compositeAcceleration(first, second)), new FieldAngularCoordinates<T>(FieldTransform.compositeRotation(first, second), FieldTransform.compositeRotationRate(first, second), FieldTransform.compositeRotationAcceleration(first, second)));
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> getIdentity(Field<T> field) {
        return new FieldIdentityTransform<T>(field);
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> compositeTranslation(FieldTransform<T> first, FieldTransform<T> second) {
        FieldVector3D<T> p1 = first.cartesian.getPosition();
        FieldRotation<T> r1 = first.angular.getRotation();
        FieldVector3D<T> p2 = second.cartesian.getPosition();
        return p1.add(r1.applyInverseTo(p2));
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> compositeVelocity(FieldTransform<T> first, FieldTransform<T> second) {
        FieldVector3D<T> v1 = first.cartesian.getVelocity();
        FieldRotation<T> r1 = first.angular.getRotation();
        FieldVector3D<T> o1 = first.angular.getRotationRate();
        FieldVector3D<T> p2 = second.cartesian.getPosition();
        FieldVector3D<T> v2 = second.cartesian.getVelocity();
        FieldVector3D crossP = FieldVector3D.crossProduct(o1, p2);
        return v1.add(r1.applyInverseTo(v2.add(crossP)));
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> compositeAcceleration(FieldTransform<T> first, FieldTransform<T> second) {
        FieldVector3D<T> a1 = first.cartesian.getAcceleration();
        FieldRotation<T> r1 = first.angular.getRotation();
        FieldVector3D<T> o1 = first.angular.getRotationRate();
        FieldVector3D<T> oDot1 = first.angular.getRotationAcceleration();
        FieldVector3D<T> p2 = second.cartesian.getPosition();
        FieldVector3D<T> v2 = second.cartesian.getVelocity();
        FieldVector3D<T> a2 = second.cartesian.getAcceleration();
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(o1, (FieldVector3D)FieldVector3D.crossProduct(o1, p2));
        FieldVector3D crossV = FieldVector3D.crossProduct(o1, v2);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(oDot1, p2);
        return a1.add(r1.applyInverseTo(new FieldVector3D(1.0, a2, 2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP)));
    }

    private static <T extends RealFieldElement<T>> FieldRotation<T> compositeRotation(FieldTransform<T> first, FieldTransform<T> second) {
        FieldRotation<T> r1 = first.angular.getRotation();
        FieldRotation<T> r2 = second.angular.getRotation();
        return r1.compose(r2, RotationConvention.FRAME_TRANSFORM);
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> compositeRotationRate(FieldTransform<T> first, FieldTransform<T> second) {
        FieldVector3D<T> o1 = first.angular.getRotationRate();
        FieldRotation<T> r2 = second.angular.getRotation();
        FieldVector3D<T> o2 = second.angular.getRotationRate();
        return o2.add(r2.applyTo(o1));
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> compositeRotationAcceleration(FieldTransform<T> first, FieldTransform<T> second) {
        FieldVector3D<T> o1 = first.angular.getRotationRate();
        FieldVector3D<T> oDot1 = first.angular.getRotationAcceleration();
        FieldRotation<T> r2 = second.angular.getRotation();
        FieldVector3D<T> o2 = second.angular.getRotationRate();
        FieldVector3D<T> oDot2 = second.angular.getRotationAcceleration();
        return new FieldVector3D(1.0, oDot2, 1.0, r2.applyTo(oDot1), -1.0, FieldVector3D.crossProduct(o2, (FieldVector3D)r2.applyTo(o1)));
    }

    @Override
    public AbsoluteDate getDate() {
        return this.aDate;
    }

    public FieldAbsoluteDate<T> getFieldDate() {
        return this.date;
    }

    @Override
    public FieldTransform<T> shiftedBy(double dt) {
        return new FieldTransform<double>((FieldAbsoluteDate<double>)this.date.shiftedBy(dt), this.aDate.shiftedBy(dt), (FieldPVCoordinates<double>)this.cartesian.shiftedBy(dt), this.angular.shiftedBy(dt));
    }

    public FieldTransform<T> shiftedBy(T dt) {
        return new FieldTransform<T>(this.date.shiftedBy(dt), this.aDate.shiftedBy(dt.getReal()), this.cartesian.shiftedBy(dt), this.angular.shiftedBy(dt));
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> interpolate(FieldAbsoluteDate<T> interpolationDate, Collection<FieldTransform<T>> sample) {
        return FieldTransform.interpolate(interpolationDate, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_RRA, sample);
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> interpolate(FieldAbsoluteDate<T> date, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, Collection<FieldTransform<T>> sample) {
        return FieldTransform.interpolate(date, cFilter, aFilter, sample.stream());
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> interpolate(FieldAbsoluteDate<T> date, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, Stream<FieldTransform<T>> sample) {
        ArrayList datedPV = new ArrayList();
        ArrayList datedAC = new ArrayList();
        sample.forEach(t -> {
            datedPV.add(new TimeStampedFieldPVCoordinates(t.getDate(), t.getTranslation(), t.getVelocity(), t.getAcceleration()));
            datedAC.add(new TimeStampedFieldAngularCoordinates(t.getDate(), t.getRotation(), t.getRotationRate(), t.getRotationAcceleration()));
        });
        TimeStampedFieldPVCoordinates<T> interpolatedPV = TimeStampedFieldPVCoordinates.interpolate(date, cFilter, datedPV);
        TimeStampedFieldAngularCoordinates<T> interpolatedAC = TimeStampedFieldAngularCoordinates.interpolate(date, aFilter, datedAC);
        return new FieldTransform<T>(date, date.toAbsoluteDate(), interpolatedPV, interpolatedAC);
    }

    public FieldTransform<T> getInverse() {
        FieldRotation<T> r = this.angular.getRotation();
        FieldVector3D<T> o = this.angular.getRotationRate();
        FieldVector3D<T> oDot = this.angular.getRotationAcceleration();
        FieldVector3D rp = r.applyTo(this.cartesian.getPosition());
        FieldVector3D rv = r.applyTo(this.cartesian.getVelocity());
        FieldVector3D ra = r.applyTo(this.cartesian.getAcceleration());
        FieldVector3D pInv = rp.negate();
        FieldVector3D crossP = FieldVector3D.crossProduct(o, (FieldVector3D)rp);
        FieldVector3D vInv = crossP.subtract(rv);
        FieldVector3D crossV = FieldVector3D.crossProduct(o, (FieldVector3D)rv);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(oDot, (FieldVector3D)rp);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(o, (FieldVector3D)crossP);
        FieldVector3D aInv = new FieldVector3D(-1.0, ra, 2.0, crossV, 1.0, crossDotP, -1.0, crossCrossP);
        return new FieldTransform<T>(this.date, this.aDate, new FieldPVCoordinates(pInv, vInv, aInv), this.angular.revert());
    }

    public FieldTransform<T> freeze() {
        return new FieldTransform<T>(this.date, this.aDate, new FieldPVCoordinates<T>(this.cartesian.getPosition(), FieldVector3D.getZero(this.date.getField()), FieldVector3D.getZero(this.date.getField())), new FieldAngularCoordinates<T>(this.angular.getRotation(), FieldVector3D.getZero(this.date.getField()), FieldVector3D.getZero(this.date.getField())));
    }

    public FieldVector3D<T> transformPosition(Vector3D position) {
        return this.angular.getRotation().applyTo(this.cartesian.getPosition().add(position));
    }

    public FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
        return this.angular.getRotation().applyTo(position.add(this.cartesian.getPosition()));
    }

    public FieldVector3D<T> transformVector(Vector3D vector) {
        return this.angular.getRotation().applyTo(vector);
    }

    public FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
        return this.angular.getRotation().applyTo(vector);
    }

    public FieldLine<T> transformLine(Line line) {
        FieldVector3D<T> transformedP0 = this.transformPosition(line.getOrigin());
        FieldVector3D<T> transformedP1 = this.transformPosition(line.pointAt(1000000.0));
        return new FieldLine(transformedP0, transformedP1, 1.0E-10);
    }

    public FieldLine<T> transformLine(FieldLine<T> line) {
        FieldVector3D<T> transformedP0 = this.transformPosition(line.getOrigin());
        FieldVector3D<T> transformedP1 = this.transformPosition(line.pointAt(1000000.0));
        return new FieldLine(transformedP0, transformedP1, 1.0E-10);
    }

    public FieldPVCoordinates<T> transformPVCoordinates(PVCoordinates pv) {
        return this.angular.applyTo(new FieldPVCoordinates(this.cartesian.getPosition().add(pv.getPosition()), this.cartesian.getVelocity().add(pv.getVelocity()), this.cartesian.getAcceleration().add(pv.getAcceleration())));
    }

    public TimeStampedFieldPVCoordinates<T> transformPVCoordinates(TimeStampedPVCoordinates pv) {
        return this.angular.applyTo(new TimeStampedFieldPVCoordinates(pv.getDate(), this.cartesian.getPosition().add(pv.getPosition()), this.cartesian.getVelocity().add(pv.getVelocity()), this.cartesian.getAcceleration().add(pv.getAcceleration())));
    }

    public FieldPVCoordinates<T> transformPVCoordinates(FieldPVCoordinates<T> pv) {
        return this.angular.applyTo(new FieldPVCoordinates(pv.getPosition().add(this.cartesian.getPosition()), pv.getVelocity().add(this.cartesian.getVelocity()), pv.getAcceleration().add(this.cartesian.getAcceleration())));
    }

    public TimeStampedFieldPVCoordinates<T> transformPVCoordinates(TimeStampedFieldPVCoordinates<T> pv) {
        return this.angular.applyTo(new TimeStampedFieldPVCoordinates<T>(pv.getDate(), pv.getPosition().add(this.cartesian.getPosition()), pv.getVelocity().add(this.cartesian.getVelocity()), pv.getAcceleration().add(this.cartesian.getAcceleration())));
    }

    public void getJacobian(CartesianDerivativesFilter selector, T[][] jacobian) {
        RealFieldElement zero = (RealFieldElement)this.date.getField().getZero();
        RealFieldElement[][] mData = this.angular.getRotation().getMatrix();
        System.arraycopy(mData[0], 0, jacobian[0], 0, 3);
        System.arraycopy(mData[1], 0, jacobian[1], 0, 3);
        System.arraycopy(mData[2], 0, jacobian[2], 0, 3);
        if (selector.getMaxOrder() >= 1) {
            Arrays.fill(jacobian[0], 3, 6, zero);
            Arrays.fill(jacobian[1], 3, 6, zero);
            Arrays.fill(jacobian[2], 3, 6, zero);
            FieldVector3D<T> o = this.angular.getRotationRate();
            RealFieldElement ox = o.getX();
            RealFieldElement oy = o.getY();
            RealFieldElement oz = o.getZ();
            for (int i = 0; i < 3; ++i) {
                jacobian[3][i] = (RealFieldElement)((RealFieldElement)oz.multiply((Object)mData[1][i])).subtract(oy.multiply((Object)mData[2][i]));
                jacobian[4][i] = (RealFieldElement)((RealFieldElement)ox.multiply((Object)mData[2][i])).subtract(oz.multiply((Object)mData[0][i]));
                jacobian[5][i] = (RealFieldElement)((RealFieldElement)oy.multiply((Object)mData[0][i])).subtract(ox.multiply((Object)mData[1][i]));
            }
            System.arraycopy(mData[0], 0, jacobian[3], 3, 3);
            System.arraycopy(mData[1], 0, jacobian[4], 3, 3);
            System.arraycopy(mData[2], 0, jacobian[5], 3, 3);
            if (selector.getMaxOrder() >= 2) {
                int i;
                Arrays.fill(jacobian[0], 6, 9, zero);
                Arrays.fill(jacobian[1], 6, 9, zero);
                Arrays.fill(jacobian[2], 6, 9, zero);
                Arrays.fill(jacobian[3], 6, 9, zero);
                Arrays.fill(jacobian[4], 6, 9, zero);
                Arrays.fill(jacobian[5], 6, 9, zero);
                FieldVector3D<T> oDot = this.angular.getRotationAcceleration();
                RealFieldElement oDotx = oDot.getX();
                RealFieldElement oDoty = oDot.getY();
                RealFieldElement oDotz = oDot.getZ();
                for (i = 0; i < 3; ++i) {
                    jacobian[6][i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)oDotz.multiply((Object)mData[1][i])).subtract(oDoty.multiply((Object)mData[2][i]))).add(((RealFieldElement)oz.multiply(jacobian[4][i])).subtract(oy.multiply(jacobian[5][i])));
                    jacobian[7][i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)oDotx.multiply((Object)mData[2][i])).subtract(oDotz.multiply((Object)mData[0][i]))).add(((RealFieldElement)ox.multiply(jacobian[5][i])).subtract(oz.multiply(jacobian[3][i])));
                    jacobian[8][i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)oDoty.multiply((Object)mData[0][i])).subtract(oDotx.multiply((Object)mData[1][i]))).add(((RealFieldElement)oy.multiply(jacobian[3][i])).subtract(ox.multiply(jacobian[4][i])));
                }
                for (i = 0; i < 3; ++i) {
                    jacobian[6][i + 3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)oz.multiply((Object)mData[1][i])).subtract(oy.multiply((Object)mData[2][i]))).multiply(2);
                    jacobian[7][i + 3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)ox.multiply((Object)mData[2][i])).subtract(oz.multiply((Object)mData[0][i]))).multiply(2);
                    jacobian[8][i + 3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)oy.multiply((Object)mData[0][i])).subtract(ox.multiply((Object)mData[1][i]))).multiply(2);
                }
                System.arraycopy(mData[0], 0, jacobian[6], 6, 3);
                System.arraycopy(mData[1], 0, jacobian[7], 6, 3);
                System.arraycopy(mData[2], 0, jacobian[8], 6, 3);
            }
        }
    }

    public FieldPVCoordinates<T> getCartesian() {
        return this.cartesian;
    }

    public FieldVector3D<T> getTranslation() {
        return this.cartesian.getPosition();
    }

    public FieldVector3D<T> getVelocity() {
        return this.cartesian.getVelocity();
    }

    public FieldVector3D<T> getAcceleration() {
        return this.cartesian.getAcceleration();
    }

    public FieldAngularCoordinates<T> getAngular() {
        return this.angular;
    }

    public FieldRotation<T> getRotation() {
        return this.angular.getRotation();
    }

    public FieldVector3D<T> getRotationRate() {
        return this.angular.getRotationRate();
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.angular.getRotationAcceleration();
    }

    private static class FieldIdentityTransform<T extends RealFieldElement<T>>
    extends FieldTransform<T> {
        FieldIdentityTransform(Field<T> field) {
            super(FieldAbsoluteDate.getJ2000Epoch(field), AbsoluteDate.J2000_EPOCH, FieldPVCoordinates.getZero(field), FieldAngularCoordinates.getIdentity(field));
        }

        @Override
        public FieldTransform<T> shiftedBy(double dt) {
            return this;
        }

        @Override
        public FieldTransform<T> getInverse() {
            return this;
        }

        @Override
        public FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
            return position;
        }

        @Override
        public FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
            return vector;
        }

        @Override
        public FieldLine<T> transformLine(FieldLine<T> line) {
            return line;
        }

        @Override
        public FieldPVCoordinates<T> transformPVCoordinates(FieldPVCoordinates<T> pv) {
            return pv;
        }

        @Override
        public void getJacobian(CartesianDerivativesFilter selector, T[][] jacobian) {
            int n = 3 * (selector.getMaxOrder() + 1);
            for (int i = 0; i < n; ++i) {
                Arrays.fill(jacobian[i], 0, n, this.getFieldDate().getField().getZero());
                jacobian[i][i] = (RealFieldElement)this.getFieldDate().getField().getOne();
            }
        }
    }
}

