/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.stream.Stream;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.los.TimeIndependentLOSTransform;
import org.orekit.rugged.utils.DSGenerator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FixedZHomothety
implements TimeIndependentLOSTransform {
    private final double SCALE = FastMath.scalb((double)1.0, (int)0);
    private double factor;
    private DerivativeStructure factorDS;
    private final ParameterDriver factorDriver;

    public FixedZHomothety(String name, double factorvalue) {
        this.factor = factorvalue;
        this.factorDS = null;
        this.factorDriver = new ParameterDriver(name, factorvalue, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.factorDriver.addObserver(new ParameterObserver(){

            public void valueChanged(double previousValue, ParameterDriver driver) {
                FixedZHomothety.this.factor = 0.0;
                FixedZHomothety.this.factorDS = null;
            }
        });
    }

    @Override
    public Stream<ParameterDriver> getParametersDrivers() {
        return Stream.of(this.factorDriver);
    }

    @Override
    public Vector3D transformLOS(int i, Vector3D los) {
        if (this.factor == 0.0) {
            this.factor = this.factorDriver.getValue();
        }
        return new Vector3D(los.getX(), los.getY(), this.factor * los.getZ());
    }

    @Override
    public FieldVector3D<DerivativeStructure> transformLOS(int i, FieldVector3D<DerivativeStructure> los, DSGenerator generator) {
        if (this.factorDS == null) {
            this.factorDS = generator.variable(this.factorDriver);
        }
        return new FieldVector3D(los.getX(), los.getY(), (RealFieldElement)this.factorDS.multiply((DerivativeStructure)los.getZ()));
    }
}

