/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.linesensor;

import java.util.stream.Stream;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.linesensor.LineDatation;
import org.orekit.rugged.los.TimeDependentLOS;
import org.orekit.rugged.utils.DSGenerator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class LineSensor {
    private final String name;
    private final LineDatation datationModel;
    private final Vector3D position;
    private final TimeDependentLOS los;

    public LineSensor(String name, LineDatation datationModel, Vector3D position, TimeDependentLOS los) {
        this.name = name;
        this.datationModel = datationModel;
        this.position = position;
        this.los = los;
    }

    public String getName() {
        return this.name;
    }

    public int getNbPixels() {
        return this.los.getNbPixels();
    }

    public Stream<ParameterDriver> getParametersDrivers() {
        return this.los.getParametersDrivers();
    }

    public Vector3D getLOS(AbsoluteDate date, int i) {
        Vector3D l = this.los.getLOS(i, date);
        DumpManager.dumpSensorLOS(this, date, i, l);
        return l;
    }

    public Vector3D getLOS(AbsoluteDate date, double i) {
        int iInf = FastMath.max((int)0, (int)FastMath.min((int)(this.getNbPixels() - 2), (int)((int)FastMath.floor((double)i))));
        int iSup = iInf + 1;
        Vector3D interpolatedLos = new Vector3D((double)iSup - i, this.los.getLOS(iInf, date), i - (double)iInf, this.los.getLOS(iSup, date));
        return interpolatedLos;
    }

    public FieldVector3D<DerivativeStructure> getLOSDerivatives(AbsoluteDate date, int i, DSGenerator generator) {
        return this.los.getLOSDerivatives(i, date, generator);
    }

    public FieldVector3D<DerivativeStructure> getLOSDerivatives(AbsoluteDate date, double i, DSGenerator generator) {
        int iInf = FastMath.max((int)0, (int)FastMath.min((int)(this.getNbPixels() - 2), (int)((int)FastMath.floor((double)i))));
        int iSup = iInf + 1;
        FieldVector3D interpolatedLos = new FieldVector3D((double)iSup - i, this.los.getLOSDerivatives(iInf, date, generator), i - (double)iInf, this.los.getLOSDerivatives(iSup, date, generator)).normalize();
        return interpolatedLos;
    }

    public AbsoluteDate getDate(double lineNumber) {
        AbsoluteDate date = this.datationModel.getDate(lineNumber);
        DumpManager.dumpSensorDatation(this, lineNumber, date);
        return date;
    }

    public double getLine(AbsoluteDate date) {
        double lineNumber = this.datationModel.getLine(date);
        DumpManager.dumpSensorDatation(this, lineNumber, date);
        return lineNumber;
    }

    public double getRate(double lineNumber) {
        double rate = this.datationModel.getRate(lineNumber);
        DumpManager.dumpSensorRate(this, lineNumber, rate);
        return rate;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public void dumpRate(double lineNumber) {
        double rate = this.datationModel.getRate(lineNumber);
        DumpManager.dumpSensorRate(this, lineNumber, rate);
    }
}

