/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.api.BodyRotatingFrameId;
import org.orekit.rugged.api.EllipsoidId;
import org.orekit.rugged.api.InertialFrameId;
import org.orekit.rugged.api.Rugged;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.intersection.BasicScanAlgorithm;
import org.orekit.rugged.intersection.ConstantElevationAlgorithm;
import org.orekit.rugged.intersection.IgnoreDEMAlgorithm;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.intersection.duvenhage.DuvenhageAlgorithm;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.raster.TileUpdater;
import org.orekit.rugged.refraction.AtmosphericRefraction;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class RuggedBuilder {
    private ExtendedEllipsoid ellipsoid;
    private AlgorithmId algorithmID;
    private TileUpdater tileUpdater;
    private double constantElevation;
    private int maxCachedTiles;
    private AbsoluteDate minDate;
    private AbsoluteDate maxDate;
    private double tStep;
    private double overshootTolerance;
    private Frame inertial;
    private List<TimeStampedPVCoordinates> pvSample;
    private int pvNeighborsSize;
    private CartesianDerivativesFilter pvDerivatives;
    private List<TimeStampedAngularCoordinates> aSample;
    private int aNeighborsSize;
    private AngularDerivativesFilter aDerivatives;
    private Propagator pvaPropagator;
    private double iStep;
    private int iN;
    private SpacecraftToObservedBody scToBody;
    private boolean lightTimeCorrection = true;
    private boolean aberrationOfLightCorrection = true;
    private AtmosphericRefraction atmosphericRefraction;
    private final List<LineSensor> sensors = new ArrayList<LineSensor>();
    private String name = "Rugged";

    public RuggedBuilder() {
        this.constantElevation = Double.NaN;
    }

    public RuggedBuilder setEllipsoid(EllipsoidId ellipsoidID, BodyRotatingFrameId bodyRotatingFrameID) {
        return this.setEllipsoid(RuggedBuilder.selectEllipsoid(ellipsoidID, RuggedBuilder.selectBodyRotatingFrame(bodyRotatingFrameID)));
    }

    public RuggedBuilder setEllipsoid(OneAxisEllipsoid newEllipsoid) {
        this.ellipsoid = new ExtendedEllipsoid(newEllipsoid.getEquatorialRadius(), newEllipsoid.getFlattening(), newEllipsoid.getBodyFrame());
        this.checkFramesConsistency();
        return this;
    }

    public ExtendedEllipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RuggedBuilder setAlgorithm(AlgorithmId newAlgorithmId) {
        this.algorithmID = newAlgorithmId;
        return this;
    }

    public AlgorithmId getAlgorithm() {
        return this.algorithmID;
    }

    public RuggedBuilder setDigitalElevationModel(TileUpdater newTileUpdater, int newMaxCachedTiles) {
        this.tileUpdater = newTileUpdater;
        this.maxCachedTiles = newMaxCachedTiles;
        return this;
    }

    public TileUpdater getTileUpdater() {
        return this.tileUpdater;
    }

    public RuggedBuilder setConstantElevation(double newConstantElevation) {
        this.constantElevation = newConstantElevation;
        return this;
    }

    public double getConstantElevation() {
        return this.constantElevation;
    }

    public int getMaxCachedTiles() {
        return this.maxCachedTiles;
    }

    public RuggedBuilder setTimeSpan(AbsoluteDate newMinDate, AbsoluteDate newMaxDate, double newTstep, double newOvershootTolerance) {
        this.minDate = newMinDate;
        this.maxDate = newMaxDate;
        this.tStep = newTstep;
        this.overshootTolerance = newOvershootTolerance;
        this.scToBody = null;
        return this;
    }

    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    public double getTStep() {
        return this.tStep;
    }

    public double getOvershootTolerance() {
        return this.overshootTolerance;
    }

    public RuggedBuilder setTrajectory(InertialFrameId inertialFrameId, List<TimeStampedPVCoordinates> positionsVelocities, int pvInterpolationNumber, CartesianDerivativesFilter pvFilter, List<TimeStampedAngularCoordinates> quaternions, int aInterpolationNumber, AngularDerivativesFilter aFilter) {
        return this.setTrajectory(RuggedBuilder.selectInertialFrame(inertialFrameId), positionsVelocities, pvInterpolationNumber, pvFilter, quaternions, aInterpolationNumber, aFilter);
    }

    public RuggedBuilder setTrajectory(Frame inertialFrame, List<TimeStampedPVCoordinates> positionsVelocities, int pvInterpolationNumber, CartesianDerivativesFilter pvFilter, List<TimeStampedAngularCoordinates> quaternions, int aInterpolationNumber, AngularDerivativesFilter aFilter) {
        this.inertial = inertialFrame;
        this.pvSample = positionsVelocities;
        this.pvNeighborsSize = pvInterpolationNumber;
        this.pvDerivatives = pvFilter;
        this.aSample = quaternions;
        this.aNeighborsSize = aInterpolationNumber;
        this.aDerivatives = aFilter;
        this.pvaPropagator = null;
        this.iStep = Double.NaN;
        this.iN = -1;
        this.scToBody = null;
        return this;
    }

    public RuggedBuilder setTrajectory(double interpolationStep, int interpolationNumber, CartesianDerivativesFilter pvFilter, AngularDerivativesFilter aFilter, Propagator propagator) {
        this.inertial = propagator.getFrame();
        this.pvSample = null;
        this.pvNeighborsSize = -1;
        this.pvDerivatives = pvFilter;
        this.aSample = null;
        this.aNeighborsSize = -1;
        this.aDerivatives = aFilter;
        this.pvaPropagator = propagator;
        this.iStep = interpolationStep;
        this.iN = interpolationNumber;
        this.scToBody = null;
        return this;
    }

    public Frame getInertialFrame() {
        return this.inertial;
    }

    public List<TimeStampedPVCoordinates> getPositionsVelocities() {
        return this.pvSample;
    }

    public int getPVInterpolationNumber() {
        return this.pvNeighborsSize;
    }

    public CartesianDerivativesFilter getPVFilter() {
        return this.pvDerivatives;
    }

    public List<TimeStampedAngularCoordinates> getQuaternions() {
        return this.aSample;
    }

    public int getAInterpolationNumber() {
        return this.aNeighborsSize;
    }

    public AngularDerivativesFilter getAFilter() {
        return this.aDerivatives;
    }

    public RuggedBuilder setTrajectoryAndTimeSpan(InputStream storageStream) {
        try {
            this.inertial = null;
            this.pvSample = null;
            this.pvNeighborsSize = -1;
            this.pvDerivatives = null;
            this.aSample = null;
            this.aNeighborsSize = -1;
            this.aDerivatives = null;
            this.pvaPropagator = null;
            this.iStep = Double.NaN;
            this.iN = -1;
            this.scToBody = (SpacecraftToObservedBody)new ObjectInputStream(storageStream).readObject();
            this.minDate = this.scToBody.getMinDate();
            this.maxDate = this.scToBody.getMaxDate();
            this.tStep = this.scToBody.getTStep();
            this.overshootTolerance = this.scToBody.getOvershootTolerance();
            this.checkFramesConsistency();
            return this;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuggedException(cnfe, RuggedMessages.NOT_INTERPOLATOR_DUMP_DATA, new Object[0]);
        }
        catch (ClassCastException cce) {
            throw new RuggedException(cce, RuggedMessages.NOT_INTERPOLATOR_DUMP_DATA, new Object[0]);
        }
        catch (IOException ioe) {
            throw new RuggedException(ioe, RuggedMessages.NOT_INTERPOLATOR_DUMP_DATA, new Object[0]);
        }
    }

    public void storeInterpolator(OutputStream storageStream) {
        try {
            this.createInterpolatorIfNeeded();
            new ObjectOutputStream(storageStream).writeObject(this.scToBody);
        }
        catch (IOException ioe) {
            throw new RuggedException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getMessage());
        }
    }

    private void checkFramesConsistency() {
        if (this.ellipsoid != null && this.scToBody != null && !this.ellipsoid.getBodyFrame().getName().equals(this.scToBody.getBodyFrame().getName())) {
            throw new RuggedException(RuggedMessages.FRAMES_MISMATCH_WITH_INTERPOLATOR_DUMP, this.ellipsoid.getBodyFrame().getName(), this.scToBody.getBodyFrame().getName());
        }
    }

    private void createInterpolatorIfNeeded() {
        if (this.ellipsoid == null) {
            throw new RuggedException(RuggedMessages.UNINITIALIZED_CONTEXT, "RuggedBuilder.setEllipsoid()");
        }
        if (this.scToBody == null) {
            if (this.pvSample != null) {
                this.scToBody = RuggedBuilder.createInterpolator(this.inertial, this.ellipsoid.getBodyFrame(), this.minDate, this.maxDate, this.tStep, this.overshootTolerance, this.pvSample, this.pvNeighborsSize, this.pvDerivatives, this.aSample, this.aNeighborsSize, this.aDerivatives);
            } else if (this.pvaPropagator != null) {
                this.scToBody = RuggedBuilder.createInterpolator(this.inertial, this.ellipsoid.getBodyFrame(), this.minDate, this.maxDate, this.tStep, this.overshootTolerance, this.iStep, this.iN, this.pvDerivatives, this.aDerivatives, this.pvaPropagator);
            } else {
                throw new RuggedException(RuggedMessages.UNINITIALIZED_CONTEXT, "RuggedBuilder.setTrajectory()");
            }
        }
    }

    private static SpacecraftToObservedBody createInterpolator(Frame inertialFrame, Frame bodyFrame, AbsoluteDate minDate, AbsoluteDate maxDate, double tStep, double overshootTolerance, List<TimeStampedPVCoordinates> positionsVelocities, int pvInterpolationNumber, CartesianDerivativesFilter pvFilter, List<TimeStampedAngularCoordinates> quaternions, int aInterpolationNumber, AngularDerivativesFilter aFilter) {
        return new SpacecraftToObservedBody(inertialFrame, bodyFrame, minDate, maxDate, tStep, overshootTolerance, positionsVelocities, pvInterpolationNumber, pvFilter, quaternions, aInterpolationNumber, aFilter);
    }

    private static SpacecraftToObservedBody createInterpolator(final Frame inertialFrame, Frame bodyFrame, AbsoluteDate minDate, AbsoluteDate maxDate, double tStep, double overshootTolerance, double interpolationStep, int interpolationNumber, CartesianDerivativesFilter pvFilter, AngularDerivativesFilter aFilter, Propagator propagator) {
        final ArrayList<TimeStampedPVCoordinates> positionsVelocities = new ArrayList<TimeStampedPVCoordinates>();
        final ArrayList<TimeStampedAngularCoordinates> quaternions = new ArrayList<TimeStampedAngularCoordinates>();
        propagator.setMasterMode(interpolationStep, new OrekitFixedStepHandler(){

            public void handleStep(SpacecraftState currentState, boolean isLast) {
                AbsoluteDate date = currentState.getDate();
                TimeStampedPVCoordinates pv = currentState.getPVCoordinates(inertialFrame);
                Rotation q = currentState.getAttitude().getRotation();
                positionsVelocities.add(new TimeStampedPVCoordinates(date, pv.getPosition(), pv.getVelocity(), Vector3D.ZERO));
                quaternions.add(new TimeStampedAngularCoordinates(date, q, Vector3D.ZERO, Vector3D.ZERO));
            }
        });
        propagator.propagate(minDate.shiftedBy(-interpolationStep), maxDate.shiftedBy(interpolationStep));
        return RuggedBuilder.createInterpolator(inertialFrame, bodyFrame, minDate, maxDate, tStep, overshootTolerance, positionsVelocities, interpolationNumber, pvFilter, quaternions, interpolationNumber, aFilter);
    }

    public RuggedBuilder setLightTimeCorrection(boolean newLightTimeCorrection) {
        this.lightTimeCorrection = newLightTimeCorrection;
        return this;
    }

    public boolean getLightTimeCorrection() {
        return this.lightTimeCorrection;
    }

    public RuggedBuilder setAberrationOfLightCorrection(boolean newAberrationOfLightCorrection) {
        this.aberrationOfLightCorrection = newAberrationOfLightCorrection;
        return this;
    }

    public boolean getAberrationOfLightCorrection() {
        return this.aberrationOfLightCorrection;
    }

    public RuggedBuilder setRefractionCorrection(AtmosphericRefraction newAtmosphericRefraction) {
        this.atmosphericRefraction = newAtmosphericRefraction;
        return this;
    }

    public AtmosphericRefraction getRefractionCorrection() {
        return this.atmosphericRefraction;
    }

    public RuggedBuilder addLineSensor(LineSensor lineSensor) {
        this.sensors.add(lineSensor);
        return this;
    }

    public RuggedBuilder clearLineSensors() {
        this.sensors.clear();
        return this;
    }

    public List<LineSensor> getLineSensors() {
        return Collections.unmodifiableList(this.sensors);
    }

    private static Frame selectInertialFrame(InertialFrameId inertialFrameId) {
        switch (inertialFrameId) {
            case GCRF: {
                return FramesFactory.getGCRF();
            }
            case EME2000: {
                return FramesFactory.getEME2000();
            }
            case MOD: {
                return FramesFactory.getMOD((IERSConventions)IERSConventions.IERS_1996);
            }
            case TOD: {
                return FramesFactory.getTOD((IERSConventions)IERSConventions.IERS_1996, (boolean)true);
            }
            case VEIS1950: {
                return FramesFactory.getVeis1950();
            }
        }
        throw new RuggedInternalError(null);
    }

    private static Frame selectBodyRotatingFrame(BodyRotatingFrameId bodyRotatingFrame) {
        switch (bodyRotatingFrame) {
            case ITRF: {
                return FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
            }
            case ITRF_EQUINOX: {
                return FramesFactory.getITRFEquinox((IERSConventions)IERSConventions.IERS_1996, (boolean)true);
            }
            case GTOD: {
                return FramesFactory.getGTOD((IERSConventions)IERSConventions.IERS_1996, (boolean)true);
            }
        }
        throw new RuggedInternalError(null);
    }

    private static OneAxisEllipsoid selectEllipsoid(EllipsoidId ellipsoidID, Frame bodyFrame) {
        switch (ellipsoidID) {
            case GRS80: {
                return new OneAxisEllipsoid(6378137.0, 0.003352810681182319, bodyFrame);
            }
            case WGS84: {
                return new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, bodyFrame);
            }
            case IERS96: {
                return new OneAxisEllipsoid(6378136.49, 0.003352819360654229, bodyFrame);
            }
            case IERS2003: {
                return new OneAxisEllipsoid(6378136.6, 0.003352819697896193, bodyFrame);
            }
        }
        throw new RuggedInternalError(null);
    }

    private static IntersectionAlgorithm createAlgorithm(AlgorithmId algorithmID, TileUpdater updater, int maxCachedTiles, double constantElevation) {
        switch (algorithmID) {
            case DUVENHAGE: {
                return new DuvenhageAlgorithm(updater, maxCachedTiles, false);
            }
            case DUVENHAGE_FLAT_BODY: {
                return new DuvenhageAlgorithm(updater, maxCachedTiles, true);
            }
            case BASIC_SLOW_EXHAUSTIVE_SCAN_FOR_TESTS_ONLY: {
                return new BasicScanAlgorithm(updater, maxCachedTiles);
            }
            case CONSTANT_ELEVATION_OVER_ELLIPSOID: {
                return new ConstantElevationAlgorithm(constantElevation);
            }
            case IGNORE_DEM_USE_ELLIPSOID: {
                return new IgnoreDEMAlgorithm();
            }
        }
        throw new RuggedInternalError(null);
    }

    public Rugged build() {
        if (this.algorithmID == null) {
            throw new RuggedException(RuggedMessages.UNINITIALIZED_CONTEXT, "RuggedBuilder.setAlgorithmID()");
        }
        if (this.algorithmID == AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID) {
            if (Double.isNaN(this.constantElevation)) {
                throw new RuggedException(RuggedMessages.UNINITIALIZED_CONTEXT, "RuggedBuilder.setConstantElevation()");
            }
        } else if (this.algorithmID != AlgorithmId.IGNORE_DEM_USE_ELLIPSOID && this.tileUpdater == null) {
            throw new RuggedException(RuggedMessages.UNINITIALIZED_CONTEXT, "RuggedBuilder.setDigitalElevationModel()");
        }
        this.createInterpolatorIfNeeded();
        return new Rugged(RuggedBuilder.createAlgorithm(this.algorithmID, this.tileUpdater, this.maxCachedTiles, this.constantElevation), this.ellipsoid, this.lightTimeCorrection, this.aberrationOfLightCorrection, this.atmosphericRefraction, this.scToBody, this.sensors, this.name);
    }
}

