/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.adjustment.OptimizationProblemBuilder;
import org.orekit.rugged.adjustment.measurements.Observables;
import org.orekit.rugged.adjustment.measurements.SensorToGroundMapping;
import org.orekit.rugged.api.Rugged;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.utils.ParameterDriver;

public class GroundOptimizationProblemBuilder
extends OptimizationProblemBuilder {
    private static final String TARGET = "Target";
    private static final String WEIGHT = "Weight";
    private final Rugged rugged;
    private List<SensorToGroundMapping> sensorToGroundMappings;
    private int minLine;
    private int maxLine;
    private HashMap<String, double[]> targetAndWeight;

    public GroundOptimizationProblemBuilder(List<LineSensor> sensors, Observables measurements, Rugged rugged) {
        super(sensors, measurements);
        this.rugged = rugged;
        this.initMapping();
    }

    @Override
    protected void initMapping() {
        String ruggedName = this.rugged.getName();
        this.sensorToGroundMappings = new ArrayList<SensorToGroundMapping>();
        for (LineSensor lineSensor : this.getSensors()) {
            SensorToGroundMapping mapping = this.getMeasurements().getGroundMapping(ruggedName, lineSensor.getName());
            if (mapping == null) continue;
            this.sensorToGroundMappings.add(mapping);
        }
    }

    @Override
    protected void createTargetAndWeight() {
        int n = 0;
        for (SensorToGroundMapping reference : this.sensorToGroundMappings) {
            n += reference.getMapping().size();
        }
        if (n == 0) {
            throw new RuggedException(RuggedMessages.NO_REFERENCE_MAPPINGS, new Object[0]);
        }
        double[] target = new double[2 * n];
        double[] weight = new double[2 * n];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        for (SensorToGroundMapping reference : this.sensorToGroundMappings) {
            for (Map.Entry<SensorPixel, GeodeticPoint> mapping : reference.getMapping()) {
                SensorPixel sp = mapping.getKey();
                weight[k] = 1.0;
                target[k++] = sp.getLineNumber();
                weight[k] = 1.0;
                target[k++] = sp.getPixelNumber();
                min = FastMath.min((double)min, (double)sp.getLineNumber());
                max = FastMath.max((double)max, (double)sp.getLineNumber());
            }
        }
        this.minLine = (int)FastMath.floor((double)(min - 100.0));
        this.maxLine = (int)FastMath.ceil((double)(max - 100.0));
        this.targetAndWeight = new HashMap();
        this.targetAndWeight.put(TARGET, target);
        this.targetAndWeight.put(WEIGHT, weight);
    }

    @Override
    protected MultivariateJacobianFunction createFunction() {
        MultivariateJacobianFunction model = point -> {
            int i = 0;
            for (ParameterDriver driver : this.getDrivers()) {
                driver.setNormalizedValue(point.getEntry(i++));
            }
            double[] target = this.targetAndWeight.get(TARGET);
            ArrayRealVector value = new ArrayRealVector(target.length);
            Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(target.length, this.getNbParams());
            int l = 0;
            for (SensorToGroundMapping reference : this.sensorToGroundMappings) {
                for (Map.Entry<SensorPixel, GeodeticPoint> mapping : reference.getMapping()) {
                    GeodeticPoint gp = mapping.getValue();
                    DerivativeStructure[] ilResult = this.rugged.inverseLocationDerivatives(reference.getSensorName(), gp, this.minLine, this.maxLine, this.getGenerator());
                    if (ilResult == null) {
                        value.setEntry(l, (double)this.minLine - 100.0);
                        value.setEntry(l + 1, -100.0);
                    } else {
                        value.setEntry(l, ilResult[0].getValue());
                        value.setEntry(l + 1, ilResult[1].getValue());
                        int[] orders = new int[this.getNbParams()];
                        int m = 0;
                        for (ParameterDriver driver : this.getDrivers()) {
                            double scale = driver.getScale();
                            orders[m] = 1;
                            jacobian.setEntry(l, m, ilResult[0].getPartialDerivative(orders) * scale);
                            jacobian.setEntry(l + 1, m, ilResult[1].getPartialDerivative(orders) * scale);
                            orders[m] = 0;
                            ++m;
                        }
                    }
                    l += 2;
                }
            }
            return new Pair((Object)value, (Object)jacobian);
        };
        return model;
    }

    @Override
    public final LeastSquaresProblem build(int maxEvaluations, double convergenceThreshold) {
        this.createTargetAndWeight();
        double[] target = this.targetAndWeight.get(TARGET);
        double[] start = this.createStartTab();
        ParameterValidator validator = this.createParameterValidator();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = this.createChecker(convergenceThreshold);
        MultivariateJacobianFunction model = this.createFunction();
        return new LeastSquaresBuilder().lazyEvaluation(false).maxIterations(maxEvaluations).maxEvaluations(maxEvaluations).weight(null).start(start).target(target).parameterValidator(validator).checker(checker).model(model).build();
    }
}

