/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.stream.Stream;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AbsolutePVCoordinates
extends TimeStampedPVCoordinates
implements TimeStamped,
TimeInterpolable<AbsolutePVCoordinates>,
Serializable,
PVCoordinatesProvider {
    private static final long serialVersionUID = 20150824L;
    private final Frame frame;

    public AbsolutePVCoordinates(Frame frame, AbsoluteDate date, Vector3D position, Vector3D velocity, Vector3D acceleration) {
        super(date, position, velocity, acceleration);
        this.frame = frame;
    }

    public AbsolutePVCoordinates(Frame frame, AbsoluteDate date, Vector3D position, Vector3D velocity) {
        this(frame, date, position, velocity, Vector3D.ZERO);
    }

    public AbsolutePVCoordinates(Frame frame, AbsoluteDate date, PVCoordinates pva) {
        super(date, pva);
        this.frame = frame;
    }

    public AbsolutePVCoordinates(Frame frame, TimeStampedPVCoordinates pva) {
        super(pva.getDate(), (PVCoordinates)pva);
        this.frame = frame;
    }

    public AbsolutePVCoordinates(AbsoluteDate date, double a, AbsolutePVCoordinates AbsPva) {
        super(date, a, (PVCoordinates)AbsPva);
        this.frame = AbsPva.frame;
    }

    public AbsolutePVCoordinates(AbsoluteDate date, AbsolutePVCoordinates start, AbsolutePVCoordinates end) {
        super(date, start, (PVCoordinates)end);
        AbsolutePVCoordinates.ensureIdenticalFrames(start, end);
        this.frame = start.frame;
    }

    public AbsolutePVCoordinates(AbsoluteDate date, double a1, AbsolutePVCoordinates absPv1, double a2, AbsolutePVCoordinates absPv2) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates());
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        this.frame = absPv1.getFrame();
    }

    public AbsolutePVCoordinates(AbsoluteDate date, double a1, AbsolutePVCoordinates absPv1, double a2, AbsolutePVCoordinates absPv2, double a3, AbsolutePVCoordinates absPv3) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates());
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        this.frame = absPv1.getFrame();
    }

    public AbsolutePVCoordinates(AbsoluteDate date, double a1, AbsolutePVCoordinates absPv1, double a2, AbsolutePVCoordinates absPv2, double a3, AbsolutePVCoordinates absPv3, double a4, AbsolutePVCoordinates absPv4) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates(), a4, absPv4.getPVCoordinates());
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        AbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv4);
        this.frame = absPv1.getFrame();
    }

    public AbsolutePVCoordinates(Frame frame, AbsoluteDate date, FieldVector3D<DerivativeStructure> p) {
        super(date, p);
        this.frame = frame;
    }

    private static void ensureIdenticalFrames(AbsolutePVCoordinates absPv1, AbsolutePVCoordinates absPv2) throws OrekitIllegalArgumentException {
        if (!absPv1.frame.equals(absPv2.frame)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.INCOMPATIBLE_FRAMES, absPv1.frame.getName(), absPv2.frame.getName());
        }
    }

    @Override
    public AbsolutePVCoordinates shiftedBy(double dt) {
        TimeStampedPVCoordinates spv = super.shiftedBy(dt);
        return new AbsolutePVCoordinates(this.frame, spv);
    }

    public PVCoordinatesProvider toTaylorProvider() {
        return new PVCoordinatesProvider(){

            @Override
            public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate d, Frame f) {
                AbsolutePVCoordinates shifted = AbsolutePVCoordinates.this.shiftedBy(d.durationFrom(AbsolutePVCoordinates.this.getDate()));
                Transform transform = AbsolutePVCoordinates.this.frame.getTransformTo(f, d);
                return transform.transformPVCoordinates(shifted);
            }
        };
    }

    public Frame getFrame() {
        return this.frame;
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        return this;
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) {
        if (outputFrame == this.frame) {
            return this.getPVCoordinates();
        }
        Transform t = this.frame.getTransformTo(outputFrame, this.getDate());
        return t.transformPVCoordinates(this.getPVCoordinates());
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate otherDate, Frame outputFrame) {
        return this.shiftedBy(otherDate.durationFrom(this.getDate())).getPVCoordinates(outputFrame);
    }

    @Override
    public AbsolutePVCoordinates interpolate(AbsoluteDate date, Stream<AbsolutePVCoordinates> sample) {
        return AbsolutePVCoordinates.interpolate(this.getFrame(), date, CartesianDerivativesFilter.USE_PVA, sample);
    }

    public static AbsolutePVCoordinates interpolate(Frame frame, AbsoluteDate date, CartesianDerivativesFilter filter, Stream<AbsolutePVCoordinates> sample) {
        HermiteInterpolator interpolator = new HermiteInterpolator();
        switch (filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    Vector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        double[][] p = interpolator.derivatives(0.0, 2);
        return new AbsolutePVCoordinates(frame, date, new Vector3D(p[0]), new Vector3D(p[1]), new Vector3D(p[2]));
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20150916L;
        private double[] d;
        private final Frame frame;

        private DTO(AbsolutePVCoordinates absPva) {
            double epoch = FastMath.floor((double)absPva.getDate().durationFrom(AbsoluteDate.J2000_EPOCH));
            double offset = absPva.getDate().durationFrom(AbsoluteDate.J2000_EPOCH.shiftedBy(epoch));
            this.d = new double[]{epoch, offset, absPva.getPosition().getX(), absPva.getPosition().getY(), absPva.getPosition().getZ(), absPva.getVelocity().getX(), absPva.getVelocity().getY(), absPva.getVelocity().getZ(), absPva.getAcceleration().getX(), absPva.getAcceleration().getY(), absPva.getAcceleration().getZ()};
            this.frame = absPva.frame;
        }

        private Object readResolve() {
            return new AbsolutePVCoordinates(this.frame, AbsoluteDate.J2000_EPOCH.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[2], this.d[3], this.d[4]), new Vector3D(this.d[5], this.d[6], this.d[7]), new Vector3D(this.d[8], this.d[9], this.d[10]));
        }
    }
}

