/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.OffsetModel;
import org.orekit.time.UTCTAIOffsetsLoader;

public class TAIUTCDatFilesLoader
implements UTCTAIOffsetsLoader {
    public static final String DEFAULT_SUPPORTED_NAMES = "^tai-utc\\.dat$";
    private final String supportedNames;

    public TAIUTCDatFilesLoader(String supportedNames) {
        this.supportedNames = supportedNames;
    }

    @Override
    public List<OffsetModel> loadOffsets() {
        Parser parser = new Parser();
        DataProvidersManager.getInstance().feed(this.supportedNames, parser);
        return parser.getOffsets();
    }

    private static class Parser
    implements DataLoader {
        private static final String BLANKS = "\\p{Blank}*";
        private static final String STORAGE_START = "(";
        private static final String STORAGE_END = ")";
        private static final String ALTERNATIVE = "|";
        private static final String LINE_START_REGEXP = "^\\p{Blank}*";
        private static final String LINE_END_REGEXP = "\\p{Blank}*$";
        private static final String INTEGER_REGEXP = "[-+]?\\p{Digit}+";
        private static final String REAL_REGEXP = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        private static final String STORED_INTEGER_FIELD = "\\p{Blank}*([-+]?\\p{Digit}+)";
        private static final String STORED_REAL_FIELD = "\\p{Blank}*([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)";
        private Pattern dataPattern;
        private List<OffsetModel> offsets;

        Parser() {
            StringBuilder builder = new StringBuilder("\\p{Blank}*(");
            for (Month month : Month.values()) {
                builder.append(month.getUpperCaseAbbreviation());
                builder.append(ALTERNATIVE);
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append(STORAGE_END);
            String monthField = builder.toString();
            this.dataPattern = Pattern.compile("^\\p{Blank}*\\p{Blank}*([-+]?\\p{Digit}+)" + monthField + STORED_INTEGER_FIELD + "\\p{Blank}+=JD" + STORED_REAL_FIELD + "\\p{Blank}+TAI-UTC=" + STORED_REAL_FIELD + "\\p{Blank}+S\\p{Blank}+\\+\\p{Blank}+\\(MJD\\p{Blank}+-" + STORED_REAL_FIELD + "\\p{Blank}*\\)\\p{Blank}+X" + STORED_REAL_FIELD + "\\p{Blank}*S" + LINE_END_REGEXP);
            this.offsets = new ArrayList<OffsetModel>();
        }

        public List<OffsetModel> getOffsets() {
            return this.offsets;
        }

        @Override
        public boolean stillAcceptsData() {
            return this.offsets.isEmpty();
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            this.offsets.clear();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            int lineNumber = 0;
            DateComponents lastDate = null;
            String line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                Matcher matcher = this.dataPattern.matcher(line);
                if (matcher.matches()) {
                    try {
                        DateComponents dc1 = new DateComponents(Integer.parseInt(matcher.group(1)), Month.parseMonth(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                        DateComponents dc2 = new DateComponents(DateComponents.JULIAN_EPOCH, (int)FastMath.ceil((double)Double.parseDouble(matcher.group(4))));
                        if (!dc1.equals(dc2)) {
                            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, dc1.getYear(), dc1.getMonth(), dc1.getDay(), dc2.getMJD());
                        }
                        if (lastDate != null && dc1.compareTo(lastDate) <= 0) {
                            throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICAL_DATES_IN_FILE, name, lineNumber);
                        }
                        lastDate = dc1;
                        double offset = Double.parseDouble(matcher.group(5));
                        double mjdRef = Double.parseDouble(matcher.group(6));
                        double slope = Double.parseDouble(matcher.group(7));
                        this.offsets.add(new OffsetModel(dc1, (int)FastMath.rint((double)mjdRef), offset, slope));
                    }
                    catch (NumberFormatException nfe) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                }
                line = reader.readLine();
            }
            if (this.offsets.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NO_ENTRIES_IN_IERS_UTC_TAI_HISTORY_FILE, name);
            }
        }
    }
}

