/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;

public class GLONASSDate
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 20190131L;
    private static final int C1 = 44195;
    private static final int C2 = 45290;
    private final int na;
    private final int n4;
    private final double secInNa;
    private double jd0;
    private double gmst;
    private final transient AbsoluteDate date;

    public GLONASSDate(int na, int n4, double secInNa) {
        this.na = na;
        this.n4 = n4;
        this.secInNa = secInNa;
        int ratio = FastMath.round((float)((float)(na - 3) / 89510.0f));
        this.jd0 = (double)(1461 * (n4 - 1) + na) + 2450082.5 - (double)ratio;
        this.gmst = this.computeGMST();
        this.date = this.computeDate();
    }

    public GLONASSDate(AbsoluteDate date) {
        DateTimeComponents dateTime = date.getComponents(TimeScalesFactory.getGLONASS());
        int year = dateTime.getDate().getYear();
        this.n4 = (year - 1996) / 4 + 1;
        int start = 1996 + 4 * (this.n4 - 1);
        double duration = date.durationFrom(new AbsoluteDate(start, 1, 1, (TimeScale)TimeScalesFactory.getGLONASS()));
        this.na = (int)(duration / 86400.0) + 1;
        this.secInNa = dateTime.getTime().getSecondsInLocalDay();
        int ratio = FastMath.round((float)((float)(this.na - 3) / 89510.0f));
        this.jd0 = (double)(1461 * (this.n4 - 1) + this.na) + 2450082.5 - (double)ratio;
        this.gmst = this.computeGMST();
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public double getSecInDay() {
        return this.secInNa;
    }

    public int getDayNumber() {
        return this.na;
    }

    public int getIntervalNumber() {
        return this.n4;
    }

    public double getJD0() {
        return this.jd0;
    }

    public double getGMST() {
        return this.gmst;
    }

    private double computeGMST() {
        double ref = 2451545.0;
        double era = 6.28318530717958 * (0.779057273264 + 1.0027378119113546 * (this.jd0 - 2451545.0));
        double time = (this.jd0 - 2451545.0) / 3.15576E9;
        double time2 = time * time;
        double time3 = time2 * time;
        double time4 = time2 * time2;
        double time5 = time2 * time3;
        double gTime = era + 7.03270726E-8 + time * 0.0223603658710194 + time2 * 6.7465784654E-6 - time3 * 2.1332E-12 - time4 * 1.452308E-10 - time5 * 1.784E-13;
        return gTime;
    }

    private AbsoluteDate computeDate() {
        double jdn = this.jd0 + 0.5;
        int a = (int)(jdn + 32044.0);
        int b = (4 * a + 3) / 146097;
        int c = a - 146097 * b / 4;
        int d = (4 * c + 3) / 1461;
        int e = c - 1461 * d / 4;
        int m = (5 * e + 2) / 153;
        int day = e - (153 * m + 2) / 5 + 1;
        int month = m + 3 - 12 * (m / 10);
        int year = 100 * b + d - 4800 + m / 10;
        return new AbsoluteDate(new DateComponents(year, month, day), new TimeComponents(this.secInNa), (TimeScale)TimeScalesFactory.getGLONASS());
    }

    private Object writeReplace() {
        return new DataTransferObject(this.na, this.n4, this.secInNa);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20190131L;
        private final int na;
        private final int n4;
        private final double secInNa;

        DataTransferObject(int na, int n4, double secInNa) {
            this.na = na;
            this.n4 = n4;
            this.secInNa = secInNa;
        }

        private Object readResolve() {
            return new GLONASSDate(this.na, this.n4, this.secInNa);
        }
    }
}

