/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.InterpolationGrid;

public class MaxGapInterpolationGrid
implements InterpolationGrid {
    private final double maxGap;

    public MaxGapInterpolationGrid(double maxGap) {
        this.maxGap = maxGap;
    }

    @Override
    public double[] getGridPoints(double stepStart, double stepEnd) {
        int pointsPerStep = FastMath.max((int)2, (int)((int)FastMath.ceil((double)(FastMath.abs((double)(stepEnd - stepStart)) / this.maxGap))));
        double[] grid = new double[pointsPerStep];
        double stepSize = (stepEnd - stepStart) / (double)(pointsPerStep - 1);
        for (int i = 0; i < pointsPerStep; ++i) {
            grid[i] = stepSize * (double)i + stepStart;
        }
        return grid;
    }
}

