/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.time.FieldAbsoluteDate;

public class FieldAuxiliaryElements<T extends RealFieldElement<T>> {
    public static final double TWO_PI = Math.PI * 2;
    private final FieldAbsoluteDate<T> date;
    private final Frame frame;
    private final T ecc;
    private final T n;
    private final T period;
    private final T sma;
    private final T k;
    private final T h;
    private final T q;
    private final T p;
    private final T lm;
    private final T lv;
    private final T le;
    private final int I;
    private final T B;
    private final T C;
    private final FieldVector3D<T> f;
    private final FieldVector3D<T> g;
    private final FieldVector3D<T> w;
    private final T alpha;
    private final T beta;
    private final T gamma;

    public FieldAuxiliaryElements(FieldOrbit<T> orbit, int retrogradeFactor) {
        Field<T> field = orbit.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement pi = (RealFieldElement)zero.add(Math.PI);
        this.date = orbit.getDate();
        this.frame = orbit.getFrame();
        this.ecc = orbit.getE();
        this.n = orbit.getKeplerianMeanMotion();
        this.period = orbit.getKeplerianPeriod();
        this.sma = orbit.getA();
        this.k = orbit.getEquinoctialEx();
        this.h = orbit.getEquinoctialEy();
        this.q = orbit.getHx();
        this.p = orbit.getHy();
        this.lm = this.normalizeAngle(orbit.getLM(), pi);
        this.lv = this.normalizeAngle(orbit.getLv(), pi);
        this.le = this.normalizeAngle(orbit.getLE(), pi);
        this.I = retrogradeFactor;
        RealFieldElement k2 = (RealFieldElement)this.k.multiply(this.k);
        RealFieldElement h2 = (RealFieldElement)this.h.multiply(this.h);
        RealFieldElement q2 = (RealFieldElement)this.q.multiply(this.q);
        RealFieldElement p2 = (RealFieldElement)this.p.multiply(this.p);
        this.B = FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)k2.add((Object)h2)).negate()).add(1.0)));
        this.C = (RealFieldElement)((RealFieldElement)q2.add((Object)p2)).add(1.0);
        RealFieldElement ooC = (RealFieldElement)this.C.reciprocal();
        RealFieldElement px2 = (RealFieldElement)this.p.multiply(2.0);
        RealFieldElement qx2 = (RealFieldElement)this.q.multiply(2.0);
        RealFieldElement pq2 = (RealFieldElement)px2.multiply(this.q);
        this.f = new FieldVector3D(ooC, new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)p2.negate()).add(1.0)).add((Object)q2), pq2, (RealFieldElement)((RealFieldElement)px2.multiply(this.I)).negate()));
        this.g = new FieldVector3D(ooC, new FieldVector3D((RealFieldElement)pq2.multiply(this.I), (RealFieldElement)((RealFieldElement)((RealFieldElement)p2.add(1.0)).subtract((Object)q2)).multiply(this.I), qx2));
        this.w = new FieldVector3D(ooC, new FieldVector3D(px2, (RealFieldElement)qx2.negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)p2.add((Object)q2)).negate()).add(1.0)).multiply(this.I)));
        this.alpha = this.f.getZ();
        this.beta = this.g.getZ();
        this.gamma = this.w.getZ();
    }

    public T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(FastMath.floor((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)a.add(Math.PI)).subtract(center)).divide(Math.PI * 2))).multiply(Math.PI * 2)));
    }

    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public T getEcc() {
        return this.ecc;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getKeplerianPeriod() {
        return this.period;
    }

    public T getSma() {
        return this.sma;
    }

    public T getK() {
        return this.k;
    }

    public T getH() {
        return this.h;
    }

    public T getQ() {
        return this.q;
    }

    public T getP() {
        return this.p;
    }

    public T getLM() {
        return this.lm;
    }

    public T getLv() {
        return this.lv;
    }

    public T getLe() {
        return this.le;
    }

    public int getRetrogradeFactor() {
        return this.I;
    }

    public T getB() {
        return this.B;
    }

    public T getC() {
        return this.C;
    }

    public FieldVector3D<T> getVectorF() {
        return this.f;
    }

    public FieldVector3D<T> getVectorG() {
        return this.g;
    }

    public FieldVector3D<T> getVectorW() {
        return this.w;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }
}

