/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.forces.radiation.SolarRadiationPressure;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class DSSTSolarRadiationPressure
extends AbstractGaussianContribution {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double GAUSS_THRESHOLD = 1.0E-15;
    private static final double S_ZERO = 1.0E-6;
    private static final String PREFIX = "DSST-SRP-";
    private final ExtendedPVCoordinatesProvider sun;
    private final double ae;
    private final RadiationSensitive spacecraft;

    public DSSTSolarRadiationPressure(double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(1.4959787E11, 4.56E-6, cr, area, sun, equatorialRadius, mu);
    }

    public DSSTSolarRadiationPressure(ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft, mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(dRef, pRef, sun, equatorialRadius, new IsotropicRadiationSingleCoefficient(area, cr), mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        super(PREFIX, 1.0E-15, new SolarRadiationPressure(dRef, pRef, sun, equatorialRadius, spacecraft), mu);
        this.sun = sun;
        this.ae = equatorialRadius;
        this.spacecraft = spacecraft;
    }

    public RadiationSensitive getSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    protected ParameterDriver[] getParametersDriversWithoutMu() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    @Override
    protected double[] getLLimits(SpacecraftState state, AuxiliaryElements auxiliaryElements) {
        double[] ll = new double[]{-Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0), Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0)};
        Vector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        double alpha = sunDir.dotProduct((Vector)auxiliaryElements.getVectorF());
        double beta = sunDir.dotProduct((Vector)auxiliaryElements.getVectorG());
        double gamma = sunDir.dotProduct((Vector)auxiliaryElements.getVectorW());
        if (FastMath.abs((double)(gamma * auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc()))) < this.ae) {
            double[] roots;
            double bet2 = beta * beta;
            double h2 = auxiliaryElements.getH() * auxiliaryElements.getH();
            double k2 = auxiliaryElements.getK() * auxiliaryElements.getK();
            double m = this.ae / (auxiliaryElements.getSma() * auxiliaryElements.getB());
            double m2 = m * m;
            double m4 = m2 * m2;
            double bb = alpha * beta + m2 * auxiliaryElements.getH() * auxiliaryElements.getK();
            double b2 = bb * bb;
            double cc = alpha * alpha - bet2 + m2 * (k2 - h2);
            double dd = 1.0 - bet2 - m2 * (1.0 + h2);
            double[] a = new double[]{4.0 * b2 + cc * cc, 8.0 * bb * m2 * auxiliaryElements.getH() + 4.0 * cc * m2 * auxiliaryElements.getK(), -4.0 * b2 + 4.0 * m4 * h2 - 2.0 * cc * dd + 4.0 * m4 * k2, -8.0 * bb * m2 * auxiliaryElements.getH() - 4.0 * dd * m2 * auxiliaryElements.getK(), -4.0 * m4 * h2 + dd * dd};
            int nbRoots = this.realQuarticRoots(a, roots = new double[4]);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    double cosL = roots[i];
                    double sL = FastMath.sqrt((double)((1.0 - cosL) * (1.0 + cosL)));
                    for (int j = -1; j <= 1; j += 2) {
                        double range;
                        double S;
                        double sinL = (double)j * sL;
                        double cPhi = alpha * cosL + beta * sinL;
                        if (!(cPhi < 0.0) || !(FastMath.abs((double)(S = 1.0 - m2 * (range = 1.0 + auxiliaryElements.getK() * cosL + auxiliaryElements.getH() * sinL) * range - cPhi * cPhi)) < 1.0E-6)) continue;
                        double dSdL = m2 * range * (auxiliaryElements.getK() * sinL - auxiliaryElements.getH() * cosL) + cPhi * (alpha * sinL - beta * cosL);
                        if (dSdL > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2((double)sinL, (double)cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2((double)sinL, (double)cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = -Math.PI;
                    ll[1] = Math.PI;
                }
                if (ll[0] > ll[1]) {
                    if (ll[1] < 0.0) {
                        ll[1] = ll[1] + Math.PI * 2;
                    } else {
                        ll[0] = ll[0] - Math.PI * 2;
                    }
                }
            }
        }
        return ll;
    }

    @Override
    protected <T extends RealFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements) {
        Field<T> field = state.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement[] ll = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        ll[0] = (RealFieldElement)auxiliaryElements.normalizeAngle((RealFieldElement)state.getLv(), zero).subtract(Math.PI);
        ll[1] = (RealFieldElement)auxiliaryElements.normalizeAngle((RealFieldElement)state.getLv(), zero).add(Math.PI);
        FieldVector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        RealFieldElement alpha = sunDir.dotProduct(auxiliaryElements.getVectorF());
        RealFieldElement beta = sunDir.dotProduct(auxiliaryElements.getVectorG());
        RealFieldElement gamma = sunDir.dotProduct(auxiliaryElements.getVectorW());
        if (FastMath.abs((RealFieldElement)((RealFieldElement)((RealFieldElement)gamma.multiply(auxiliaryElements.getSma())).multiply(((RealFieldElement)auxiliaryElements.getEcc().negate()).add((Object)one)))).getReal() < this.ae) {
            RealFieldElement bet2 = (RealFieldElement)beta.multiply((Object)beta);
            RealFieldElement h2 = (RealFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getH());
            RealFieldElement k2 = (RealFieldElement)auxiliaryElements.getK().multiply(auxiliaryElements.getK());
            RealFieldElement m = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getB())).divide(this.ae)).reciprocal();
            RealFieldElement m2 = (RealFieldElement)m.multiply((Object)m);
            RealFieldElement m4 = (RealFieldElement)m2.multiply((Object)m2);
            RealFieldElement bb = (RealFieldElement)((RealFieldElement)alpha.multiply((Object)beta)).add(((RealFieldElement)m2.multiply(auxiliaryElements.getH())).multiply(auxiliaryElements.getK()));
            RealFieldElement b2 = (RealFieldElement)bb.multiply((Object)bb);
            RealFieldElement cc = (RealFieldElement)((RealFieldElement)((RealFieldElement)alpha.multiply((Object)alpha)).subtract((Object)bet2)).add(m2.multiply(k2.subtract((Object)h2)));
            RealFieldElement dd = (RealFieldElement)((RealFieldElement)((RealFieldElement)bet2.add(m2.multiply(h2.add(1.0)))).negate()).add((Object)one);
            RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, (int)5);
            a[0] = (RealFieldElement)((RealFieldElement)b2.multiply(4.0)).add(cc.multiply((Object)cc));
            a[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)bb.multiply(8.0)).multiply((Object)m2)).multiply(auxiliaryElements.getH())).add(((RealFieldElement)((RealFieldElement)cc.multiply(4.0)).multiply((Object)m2)).multiply(auxiliaryElements.getK()));
            a[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m4.multiply((Object)h2)).multiply(4.0)).subtract(((RealFieldElement)cc.multiply((Object)dd)).multiply(2.0))).add(((RealFieldElement)m4.multiply((Object)k2)).multiply(4.0))).subtract(b2.multiply(4.0));
            a[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply((Object)m2)).multiply((Object)bb)).multiply(8.0)).add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply((Object)m2)).multiply((Object)dd)).multiply(4.0))).negate();
            a[4] = (RealFieldElement)((RealFieldElement)dd.multiply((Object)dd)).subtract(((RealFieldElement)m4.multiply((Object)h2)).multiply(4.0));
            RealFieldElement[] roots = (RealFieldElement[])MathArrays.buildArray(field, (int)4);
            int nbRoots = this.realQuarticRoots(a, roots, field);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    RealFieldElement cosL = roots[i];
                    RealFieldElement sL = FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cosL.negate()).add((Object)one)).multiply(cosL.add((Object)one))));
                    for (int j = -1; j <= 1; j += 2) {
                        RealFieldElement range;
                        RealFieldElement S;
                        RealFieldElement sinL = (RealFieldElement)sL.multiply(j);
                        RealFieldElement cPhi = (RealFieldElement)((RealFieldElement)cosL.multiply((Object)alpha)).add(sinL.multiply((Object)beta));
                        if (!(cPhi.getReal() < 0.0) || !(FastMath.abs((RealFieldElement)(S = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)(range = (RealFieldElement)((RealFieldElement)((RealFieldElement)cosL.multiply(auxiliaryElements.getK())).add(sinL.multiply(auxiliaryElements.getH()))).add((Object)one)).multiply((Object)range)).multiply((Object)m2)).add(cPhi.multiply((Object)cPhi))).negate()).add(1.0))).getReal() < 1.0E-6)) continue;
                        RealFieldElement dSdL = (RealFieldElement)((RealFieldElement)((RealFieldElement)m2.multiply((Object)range)).multiply(((RealFieldElement)auxiliaryElements.getK().multiply((Object)sinL)).subtract(auxiliaryElements.getH().multiply((Object)cosL)))).add(cPhi.multiply(((RealFieldElement)alpha.multiply((Object)sinL)).subtract(beta.multiply((Object)cosL))));
                        if (dSdL.getReal() > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2((RealFieldElement)sinL, (RealFieldElement)cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2((RealFieldElement)sinL, (RealFieldElement)cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = (RealFieldElement)zero.add(-Math.PI);
                    ll[1] = (RealFieldElement)zero.add(Math.PI);
                }
                if (ll[0].getReal() > ll[1].getReal()) {
                    if (ll[1].getReal() < 0.0) {
                        ll[1] = (RealFieldElement)ll[1].add(zero.add(Math.PI * 2));
                    } else {
                        ll[0] = (RealFieldElement)ll[0].subtract(zero.add(Math.PI * 2));
                    }
                }
            }
        }
        return ll;
    }

    public double getEquatorialRadius() {
        return this.ae;
    }

    private int realQuarticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, y);
        }
        double b = a[1] / a[0];
        double c = a[2] / a[0];
        double d = a[3] / a[0];
        double e = a[4] / a[0];
        double bh = b * 0.5;
        double[] z3 = new double[3];
        int i3 = this.realCubicRoots(new double[]{1.0, -c, b * d - 4.0 * e, e * (4.0 * c - b * b) - d * d}, z3);
        if (i3 == 0) {
            return 0;
        }
        double z = z3[0];
        double zh = z * 0.5;
        double p = FastMath.max((double)(z + bh * bh - c), (double)0.0);
        double q = FastMath.max((double)(zh * zh - e), (double)0.0);
        double r = bh * z - d;
        double pp = FastMath.sqrt((double)p);
        double qq = FastMath.copySign((double)FastMath.sqrt((double)q), (double)r);
        double[] y1 = new double[2];
        int n1 = this.realQuadraticRoots(new double[]{1.0, bh - pp, zh - qq}, y1);
        double[] y2 = new double[2];
        int n2 = this.realQuadraticRoots(new double[]{1.0, bh + pp, zh + qq}, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private <T extends RealFieldElement<T>> int realQuarticRoots(T[] a, T[] y, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            RealFieldElement[] aa = (RealFieldElement[])MathArrays.buildArray(field, (int)(a.length - 1));
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, (RealFieldElement[])y, (Field)field);
        }
        RealFieldElement b = (RealFieldElement)a[1].divide(a[0]);
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = (RealFieldElement)a[3].divide(a[0]);
        RealFieldElement e = (RealFieldElement)a[4].divide(a[0]);
        RealFieldElement bh = (RealFieldElement)b.multiply(0.5);
        RealFieldElement[] z3 = (RealFieldElement[])MathArrays.buildArray(field, (int)3);
        RealFieldElement[] i = (RealFieldElement[])MathArrays.buildArray(field, (int)4);
        i[0] = (RealFieldElement)zero.add(1.0);
        i[1] = (RealFieldElement)c.negate();
        i[2] = (RealFieldElement)((RealFieldElement)b.multiply((Object)d)).subtract(e.multiply(4.0));
        i[3] = (RealFieldElement)((RealFieldElement)e.multiply(((RealFieldElement)c.multiply(4.0)).subtract(b.multiply((Object)b)))).subtract(d.multiply((Object)d));
        int i3 = this.realCubicRoots(i, z3, field);
        if (i3 == 0) {
            return 0;
        }
        RealFieldElement z = z3[0];
        RealFieldElement zh = (RealFieldElement)z.multiply(0.5);
        RealFieldElement p = FastMath.max((RealFieldElement)((RealFieldElement)((RealFieldElement)z.add(bh.multiply((Object)bh))).subtract((Object)c)), (RealFieldElement)zero);
        RealFieldElement q = FastMath.max((RealFieldElement)((RealFieldElement)((RealFieldElement)zh.multiply((Object)zh)).subtract((Object)e)), (RealFieldElement)zero);
        RealFieldElement r = (RealFieldElement)((RealFieldElement)bh.multiply((Object)z)).subtract((Object)d);
        RealFieldElement pp = FastMath.sqrt((RealFieldElement)p);
        RealFieldElement qq = FastMath.copySign((RealFieldElement)FastMath.sqrt((RealFieldElement)q), (RealFieldElement)r);
        RealFieldElement[] y1 = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        RealFieldElement[] n = (RealFieldElement[])MathArrays.buildArray(field, (int)3);
        n[0] = (RealFieldElement)zero.add(1.0);
        n[1] = (RealFieldElement)bh.subtract((Object)pp);
        n[2] = (RealFieldElement)zh.subtract((Object)qq);
        int n1 = this.realQuadraticRoots(n, y1);
        RealFieldElement[] y2 = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        RealFieldElement[] nn = (RealFieldElement[])MathArrays.buildArray(field, (int)3);
        nn[0] = (RealFieldElement)zero.add(1.0);
        nn[1] = (RealFieldElement)bh.add((Object)pp);
        nn[2] = (RealFieldElement)zh.add((Object)qq);
        int n2 = this.realQuadraticRoots(nn, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private int realCubicRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, y);
        }
        double b = -a[1] / (3.0 * a[0]);
        double b2 = b * b;
        double c = a[2] / a[0];
        double p = b2 - c / 3.0;
        double d = a[3] / a[0];
        double q = b * (b2 - c * 0.5) - d * 0.5;
        double disc = p * p * p - q * q;
        if (disc < 0.0) {
            double alpha = q + FastMath.copySign((double)FastMath.sqrt((double)(-disc)), (double)q);
            double cbrtAl = FastMath.cbrt((double)alpha);
            double cbrtBe = p / cbrtAl;
            y[0] = p < 0.0 ? b + 2.0 * q / (cbrtAl * cbrtAl + cbrtBe * cbrtBe - p) : (p > 0.0 ? b + cbrtAl + cbrtBe : b + cbrtAl);
            return 1;
        }
        if (disc > 0.0) {
            double phi = FastMath.atan2((double)FastMath.sqrt((double)disc), (double)q) / 3.0;
            double sqP = 2.0 * FastMath.sqrt((double)p);
            y[0] = b + sqP * FastMath.cos((double)phi);
            y[1] = b - sqP * FastMath.cos((double)(1.0471975511965976 + phi));
            y[2] = b - sqP * FastMath.cos((double)(1.0471975511965976 - phi));
            return 3;
        }
        double cbrtQ = FastMath.cbrt((double)q);
        double root1 = b + 2.0 * cbrtQ;
        double root2 = b - cbrtQ;
        if (q < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private <T extends RealFieldElement<T>> int realCubicRoots(T[] a, T[] y, Field<T> field) {
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            RealFieldElement[] aa = (RealFieldElement[])MathArrays.buildArray(field, (int)(a.length - 1));
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, (RealFieldElement[])y);
        }
        RealFieldElement b = (RealFieldElement)((RealFieldElement)a[1].divide(a[0].multiply(3.0))).negate();
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = (RealFieldElement)a[3].divide(a[0]);
        RealFieldElement b2 = (RealFieldElement)b.multiply((Object)b);
        RealFieldElement p = (RealFieldElement)b2.subtract(c.divide(3.0));
        RealFieldElement q = (RealFieldElement)((RealFieldElement)b.multiply(b2.subtract(c.multiply(0.5)))).subtract(d.multiply(0.5));
        RealFieldElement disc = (RealFieldElement)((RealFieldElement)((RealFieldElement)p.multiply((Object)p)).multiply((Object)p)).subtract(q.multiply((Object)q));
        if (disc.getReal() < 0.0) {
            RealFieldElement alpha = (RealFieldElement)FastMath.copySign((RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)disc.negate())), (RealFieldElement)q).add((Object)q);
            RealFieldElement cbrtAl = FastMath.cbrt((RealFieldElement)alpha);
            RealFieldElement cbrtBe = (RealFieldElement)p.divide((Object)cbrtAl);
            y[0] = p.getReal() < 0.0 ? (RealFieldElement)((RealFieldElement)((RealFieldElement)q.divide(((RealFieldElement)((RealFieldElement)cbrtAl.multiply((Object)cbrtAl)).add(cbrtBe.multiply((Object)cbrtBe))).subtract((Object)p))).multiply(2.0)).add((Object)b) : (p.getReal() > 0.0 ? (RealFieldElement)((RealFieldElement)b.add((Object)cbrtAl)).add((Object)cbrtBe) : (RealFieldElement)b.add((Object)cbrtAl));
            return 1;
        }
        if (disc.getReal() > 0.0) {
            RealFieldElement phi = (RealFieldElement)FastMath.atan2((RealFieldElement)FastMath.sqrt((RealFieldElement)disc), (RealFieldElement)q).divide(3.0);
            RealFieldElement sqP = (RealFieldElement)FastMath.sqrt((RealFieldElement)p).multiply(2.0);
            y[0] = (RealFieldElement)b.add(sqP.multiply((Object)FastMath.cos((RealFieldElement)phi)));
            y[1] = (RealFieldElement)b.subtract(sqP.multiply((Object)FastMath.cos((RealFieldElement)((RealFieldElement)phi.add(1.0471975511965976)))));
            y[2] = (RealFieldElement)b.subtract(sqP.multiply((Object)FastMath.cos((RealFieldElement)((RealFieldElement)((RealFieldElement)phi.negate()).add(1.0471975511965976)))));
            return 3;
        }
        RealFieldElement cbrtQ = FastMath.cbrt((RealFieldElement)q);
        RealFieldElement root1 = (RealFieldElement)b.add(cbrtQ.multiply(2.0));
        RealFieldElement root2 = (RealFieldElement)b.subtract((Object)cbrtQ);
        if (q.getReal() < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private int realQuadraticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            if (Precision.equals((double)a[1], (double)0.0)) {
                return 0;
            }
            y[0] = -a[2] / a[1];
            return 1;
        }
        double b = -0.5 * a[1] / a[0];
        double c = a[2] / a[0];
        double d = b * b - c;
        if (d < 0.0) {
            return 0;
        }
        if (d > 0.0) {
            double y0 = b + FastMath.copySign((double)FastMath.sqrt((double)d), (double)b);
            double y1 = c / y0;
            y[0] = FastMath.max((double)y0, (double)y1);
            y[1] = FastMath.min((double)y0, (double)y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }

    private <T extends RealFieldElement<T>> int realQuadraticRoots(T[] a, T[] y) {
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            if (Precision.equals((double)a[1].getReal(), (double)0.0)) {
                return 0;
            }
            y[0] = (RealFieldElement)((RealFieldElement)a[2].divide(a[1])).negate();
            return 1;
        }
        RealFieldElement b = (RealFieldElement)((RealFieldElement)((RealFieldElement)a[1].divide(a[0])).multiply(0.5)).negate();
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = (RealFieldElement)((RealFieldElement)b.multiply((Object)b)).subtract((Object)c);
        if (d.getReal() < 0.0) {
            return 0;
        }
        if (d.getReal() > 0.0) {
            RealFieldElement y0 = (RealFieldElement)b.add((Object)FastMath.copySign((RealFieldElement)FastMath.sqrt((RealFieldElement)d), (RealFieldElement)b));
            RealFieldElement y1 = (RealFieldElement)c.divide((Object)y0);
            y[0] = FastMath.max((RealFieldElement)y0, (RealFieldElement)y1);
            y[1] = FastMath.min((RealFieldElement)y0, (RealFieldElement)y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }
}

