/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTNewtonianAttractionContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTNewtonianAttractionContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;

public class DSSTNewtonianAttraction
implements DSSTForceModel {
    public static final String CENTRAL_ATTRACTION_COEFFICIENT = "central attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;

    public DSSTNewtonianAttraction(double mu) {
        try {
            this.gmParameterDriver = new ParameterDriver(CENTRAL_ATTRACTION_COEFFICIENT, mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    public double getMu() {
        return this.gmParameterDriver.getValue();
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        return Collections.emptyList();
    }

    @Override
    public <T extends RealFieldElement<T>> List<FieldShortPeriodTerms<T>> initialize(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        return Collections.emptyList();
    }

    private DSSTNewtonianAttractionContext initializeStep(AuxiliaryElements auxiliaryElements, double[] parameters) {
        return new DSSTNewtonianAttractionContext(auxiliaryElements, parameters);
    }

    private <T extends RealFieldElement<T>> FieldDSSTNewtonianAttractionContext<T> initializeStep(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        return new FieldDSSTNewtonianAttractionContext(auxiliaryElements, parameters);
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState state, AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTNewtonianAttractionContext context = this.initializeStep(auxiliaryElements, parameters);
        double[] yDot = new double[7];
        EquinoctialOrbit orbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(state.getOrbit());
        orbit.addKeplerContribution(PositionAngle.MEAN, context.getGM(), yDot);
        return yDot;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        Field field = state.getMu().getField();
        FieldDSSTNewtonianAttractionContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)7);
        FieldEquinoctialOrbit orbit = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(state.getOrbit());
        orbit.addKeplerContribution(PositionAngle.MEAN, (RealFieldElement)context.getGM(), yDot);
        return yDot;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
    }

    @Override
    public <T extends RealFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }
}

