/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.errors.OrekitInternalError;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTDSConverter;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class DSSTJacobiansMapper
extends AbstractJacobiansMapper {
    public static final int STATE_DIMENSION = 6;
    private static final int I = 1;
    private String name;
    private final ParameterDriversList parameters;
    private Map<ParameterDriver, Integer> map;
    private final DSSTPropagator propagator;
    private double[] shortPeriodDerivatives = null;
    private PropagationType propagationType;

    DSSTJacobiansMapper(String name, ParameterDriversList parameters, DSSTPropagator propagator, Map<ParameterDriver, Integer> map, PropagationType propagationType) {
        super(name, parameters);
        this.parameters = parameters;
        this.name = name;
        this.propagator = propagator;
        this.map = map;
        this.propagationType = propagationType;
    }

    @Override
    protected double[][] getConversionJacobian(SpacecraftState state) {
        double[][] identity = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            identity[i][i] = 1.0;
        }
        return identity;
    }

    @Override
    public void setInitialJacobians(SpacecraftState state, double[][] dY1dY0, double[][] dY1dP, double[] p) {
        int j;
        int i;
        int index = 0;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                p[index++] = i == j ? 1.0 : 0.0;
            }
        }
        if (this.parameters.getNbParams() != 0) {
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < this.parameters.getNbParams(); ++j) {
                    p[index++] = dY1dP[i][j];
                }
            }
        }
    }

    @Override
    public void getStateJacobian(SpacecraftState state, double[][] dYdY0) {
        double[] p = state.getAdditionalState(this.name);
        for (int i = 0; i < 6; ++i) {
            double[] row = dYdY0[i];
            for (int j = 0; j < 6; ++j) {
                row[j] = p[i * 6 + j] + this.shortPeriodDerivatives[i * 6 + j];
            }
        }
    }

    @Override
    public void getParametersJacobian(SpacecraftState state, double[][] dYdP) {
        if (this.parameters.getNbParams() != 0) {
            double[] p = state.getAdditionalState(this.name);
            for (int i = 0; i < 6; ++i) {
                double[] row = dYdP[i];
                for (int j = 0; j < this.parameters.getNbParams(); ++j) {
                    row[j] = p[36 + (j + this.parameters.getNbParams() * i)] + this.shortPeriodDerivatives[36 + (j + this.parameters.getNbParams() * i)];
                }
            }
        }
    }

    @Override
    public int getAdditionalStateDimension() {
        return 6 * (6 + this.parameters.getNbParams());
    }

    public void setShortPeriodJacobians(SpacecraftState s) {
        double[] p = s.getAdditionalState(this.name);
        if (this.shortPeriodDerivatives == null) {
            this.shortPeriodDerivatives = new double[p.length];
        }
        switch (this.propagationType) {
            case MEAN: {
                break;
            }
            case OSCULATING: {
                int paramDim = this.parameters.getNbParams();
                int dim = 6;
                double[][] dShortPerioddState = new double[6][6];
                double[][] dShortPerioddParam = new double[6][paramDim];
                DSSTDSConverter converter = new DSSTDSConverter(s, this.propagator.getAttitudeProvider());
                for (DSSTForceModel forceModel : this.propagator.getAllForceModels()) {
                    FieldSpacecraftState<DerivativeStructure> dsState = converter.getState(forceModel);
                    DerivativeStructure[] dsParameters = converter.getParameters(dsState, forceModel);
                    FieldAuxiliaryElements<DerivativeStructure> auxiliaryElements = new FieldAuxiliaryElements<DerivativeStructure>(dsState.getOrbit(), 1);
                    DerivativeStructure zero = (DerivativeStructure)dsState.getDate().getField().getZero();
                    ArrayList shortPeriodTerms = new ArrayList();
                    shortPeriodTerms.addAll(forceModel.initialize(auxiliaryElements, this.propagationType, (RealFieldElement[])dsParameters));
                    forceModel.updateShortPeriodTerms((RealFieldElement[])dsParameters, new FieldSpacecraftState[]{dsState});
                    Object[] shortPeriod = new DerivativeStructure[6];
                    Arrays.fill(shortPeriod, zero);
                    for (FieldShortPeriodTerms spt : shortPeriodTerms) {
                        DerivativeStructure[] spVariation = (DerivativeStructure[])spt.value(dsState.getOrbit());
                        for (int i = 0; i < spVariation.length; ++i) {
                            shortPeriod[i] = shortPeriod[i].add(spVariation[i]);
                        }
                    }
                    double[] derivativesASP = shortPeriod[0].getAllDerivatives();
                    double[] derivativesExSP = shortPeriod[1].getAllDerivatives();
                    double[] derivativesEySP = shortPeriod[2].getAllDerivatives();
                    double[] derivativesHxSP = shortPeriod[3].getAllDerivatives();
                    double[] derivativesHySP = shortPeriod[4].getAllDerivatives();
                    double[] derivativesLSP = shortPeriod[5].getAllDerivatives();
                    this.addToRow(derivativesASP, 0, dShortPerioddState);
                    this.addToRow(derivativesExSP, 1, dShortPerioddState);
                    this.addToRow(derivativesEySP, 2, dShortPerioddState);
                    this.addToRow(derivativesHxSP, 3, dShortPerioddState);
                    this.addToRow(derivativesHySP, 4, dShortPerioddState);
                    this.addToRow(derivativesLSP, 5, dShortPerioddState);
                    int index = converter.getFreeStateParameters();
                    for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                        if (!driver.isSelected()) continue;
                        int parameterIndex = this.map.get(driver);
                        double[] dArray = dShortPerioddParam[0];
                        int n = parameterIndex;
                        dArray[n] = dArray[n] + derivativesASP[++index];
                        double[] dArray2 = dShortPerioddParam[1];
                        int n2 = parameterIndex;
                        dArray2[n2] = dArray2[n2] + derivativesExSP[index];
                        double[] dArray3 = dShortPerioddParam[2];
                        int n3 = parameterIndex;
                        dArray3[n3] = dArray3[n3] + derivativesEySP[index];
                        double[] dArray4 = dShortPerioddParam[3];
                        int n4 = parameterIndex;
                        dArray4[n4] = dArray4[n4] + derivativesHxSP[index];
                        double[] dArray5 = dShortPerioddParam[4];
                        int n5 = parameterIndex;
                        dArray5[n5] = dArray5[n5] + derivativesHySP[index];
                        double[] dArray6 = dShortPerioddParam[5];
                        int n6 = parameterIndex;
                        dArray6[n6] = dArray6[n6] + derivativesLSP[index];
                    }
                }
                for (int i = 0; i < 6; ++i) {
                    double[] dShortPerioddStatei = dShortPerioddState[i];
                    for (int j = 0; j < 6; ++j) {
                        this.shortPeriodDerivatives[j + 6 * i] = dShortPerioddStatei[0] * p[j] + dShortPerioddStatei[1] * p[j + 6] + dShortPerioddStatei[2] * p[j + 12] + dShortPerioddStatei[3] * p[j + 18] + dShortPerioddStatei[4] * p[j + 24] + dShortPerioddStatei[5] * p[j + 30];
                    }
                }
                int columnTop = 36;
                for (int k = 0; k < paramDim; ++k) {
                    for (int i = 0; i < 6; ++i) {
                        double[] dShortPerioddStatei = dShortPerioddState[i];
                        this.shortPeriodDerivatives[36 + (i + 6 * k)] = dShortPerioddParam[i][k] + dShortPerioddStatei[0] * p[36 + k] + dShortPerioddStatei[1] * p[36 + k + paramDim] + dShortPerioddStatei[2] * p[36 + k + 2 * paramDim] + dShortPerioddStatei[3] * p[36 + k + 3 * paramDim] + dShortPerioddStatei[4] * p[36 + k + 4 * paramDim] + dShortPerioddStatei[5] * p[36 + k + 5 * paramDim];
                    }
                }
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    private void addToRow(double[] derivatives, int index, double[][] dMeanElementRatedElement) {
        for (int i = 0; i < 6; ++i) {
            double[] dArray = dMeanElementRatedElement[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i + 1];
        }
    }
}

