/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractDSConverter;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

class DSSTDSConverter
extends AbstractDSConverter {
    private static final int FREE_STATE_PARAMETERS = 6;
    private final List<FieldSpacecraftState<DerivativeStructure>> dsStates;

    DSSTDSConverter(SpacecraftState state, AttitudeProvider provider) {
        super(6);
        DSFactory factory = new DSFactory(6, 1);
        DerivativeStructure sma = factory.variable(0, state.getA());
        DerivativeStructure ex = factory.variable(1, state.getEquinoctialEx());
        DerivativeStructure ey = factory.variable(2, state.getEquinoctialEy());
        DerivativeStructure hx = factory.variable(3, state.getHx());
        DerivativeStructure hy = factory.variable(4, state.getHy());
        DerivativeStructure l = factory.variable(5, state.getLM());
        DerivativeStructure dsMu = factory.constant(state.getMu());
        AbsoluteDate date = state.getDate();
        FieldAbsoluteDate dateField = new FieldAbsoluteDate(sma.getField(), date);
        DerivativeStructure dsM = factory.constant(state.getMass());
        FieldEquinoctialOrbit<DerivativeStructure> dsOrbit = new FieldEquinoctialOrbit<DerivativeStructure>(sma, ex, ey, hx, hy, l, PositionAngle.MEAN, state.getFrame(), dateField, dsMu);
        FieldAttitude<DerivativeStructure> dsAttitude = provider.getAttitude(dsOrbit, dsOrbit.getDate(), dsOrbit.getFrame());
        this.dsStates = new ArrayList<FieldSpacecraftState<DerivativeStructure>>();
        this.dsStates.add(new FieldSpacecraftState<DerivativeStructure>(dsOrbit, dsAttitude, dsM));
    }

    public FieldSpacecraftState<DerivativeStructure> getState(DSSTForceModel forceModel) {
        int nbParams = 0;
        for (ParameterDriver driver : forceModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.dsStates.size() < nbParams + 1) {
            this.dsStates.add(null);
        }
        if (this.dsStates.get(nbParams) == null) {
            DSFactory factory = new DSFactory(6 + nbParams, 1);
            FieldSpacecraftState<DerivativeStructure> s0 = this.dsStates.get(0);
            FieldAbsoluteDate date = new FieldAbsoluteDate(this.extend(s0.getA(), factory).getField(), s0.getDate().toAbsoluteDate());
            FieldEquinoctialOrbit<DerivativeStructure> dsOrbit = new FieldEquinoctialOrbit<DerivativeStructure>(this.extend(s0.getA(), factory), this.extend(s0.getEquinoctialEx(), factory), this.extend(s0.getEquinoctialEy(), factory), this.extend(s0.getHx(), factory), this.extend(s0.getHy(), factory), this.extend(s0.getLM(), factory), PositionAngle.MEAN, s0.getFrame(), date, this.extend(s0.getMu(), factory));
            TimeStampedFieldAngularCoordinates<DerivativeStructure> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<DerivativeStructure> dsAttitude = new FieldAttitude<DerivativeStructure>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<DerivativeStructure>(dsOrbit.getDate(), this.extend(ac0.getRotation(), factory), this.extend(ac0.getRotationRate(), factory), this.extend(ac0.getRotationAcceleration(), factory)));
            DerivativeStructure dsM = this.extend(s0.getMass(), factory);
            this.dsStates.set(nbParams, new FieldSpacecraftState<DerivativeStructure>(dsOrbit, dsAttitude, dsM));
        }
        return this.dsStates.get(nbParams);
    }

    public DerivativeStructure[] getParameters(FieldSpacecraftState<DerivativeStructure> state, DSSTForceModel forceModel) {
        DSFactory factory = state.getA().getFactory();
        ParameterDriver[] drivers = forceModel.getParametersDrivers();
        DerivativeStructure[] parameters = new DerivativeStructure[drivers.length];
        int index = 6;
        for (int i = 0; i < drivers.length; ++i) {
            parameters[i] = drivers[i].isSelected() ? factory.variable(index++, drivers[i].getValue()) : factory.constant(drivers[i].getValue());
        }
        return parameters;
    }
}

