/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class IntegratedEphemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private static final double EXTRAPOLATION_TOLERANCE = 1.0;
    private final StateMapper mapper;
    private PropagationType type;
    private final AbsoluteDate startDate;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private DenseOutputModel model;
    private final Map<String, double[]> unmanaged;

    public IntegratedEphemeris(AbsoluteDate startDate, AbsoluteDate minDate, AbsoluteDate maxDate, StateMapper mapper, PropagationType type, DenseOutputModel model, Map<String, double[]> unmanaged, List<AdditionalStateProvider> providers, String[] equations) {
        super(mapper.getAttitudeProvider());
        this.startDate = startDate;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.mapper = mapper;
        this.type = type;
        this.model = model;
        this.unmanaged = unmanaged;
        for (AdditionalStateProvider provider : providers) {
            this.addAdditionalStateProvider(provider);
        }
        for (int i = 0; i < equations.length; ++i) {
            this.addAdditionalStateProvider(new LocalProvider(equations[i], i));
        }
    }

    private ODEStateAndDerivative getInterpolatedState(AbsoluteDate date) {
        if (date.compareTo(this.minDate.shiftedBy(-1.0)) < 0 || date.compareTo(this.maxDate.shiftedBy(1.0)) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.minDate, this.maxDate);
        }
        return this.model.getInterpolatedState(date.durationFrom(this.startDate));
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        ODEStateAndDerivative os = this.getInterpolatedState(date);
        SpacecraftState state = this.mapper.mapArrayToState(this.mapper.mapDoubleToDate(os.getTime(), date), os.getPrimaryState(), os.getPrimaryDerivative(), this.type);
        for (Map.Entry<String, double[]> initial : this.unmanaged.entrySet()) {
            state = state.addAdditionalState(initial.getKey(), initial.getValue());
        }
        return state;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.mapper.getFrame();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.updateAdditionalStates(this.basicPropagate(this.getMinDate()));
    }

    private class LocalProvider
    implements AdditionalStateProvider {
        private final String name;
        private final int index;

        LocalProvider(String name, int index) {
            this.name = name;
            this.index = index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double[] getAdditionalState(SpacecraftState state) {
            return IntegratedEphemeris.this.getInterpolatedState(state.getDate()).getSecondaryState(this.index + 1);
        }
    }
}

