/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class LatitudeCrossingDetector
extends AbstractDetector<LatitudeCrossingDetector> {
    private OneAxisEllipsoid body;
    private final double latitude;

    public LatitudeCrossingDetector(OneAxisEllipsoid body, double latitude) {
        this(600.0, 1.0E-6, body, latitude);
    }

    public LatitudeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double latitude) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body, latitude);
    }

    private LatitudeCrossingDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super LatitudeCrossingDetector> handler, OneAxisEllipsoid body, double latitude) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.latitude = latitude;
    }

    @Override
    protected LatitudeCrossingDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super LatitudeCrossingDetector> newHandler) {
        return new LatitudeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.latitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double g(SpacecraftState s) {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        return gp.getLatitude() - this.latitude;
    }
}

