/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;

public class FieldLatitudeCrossingDetector<T extends RealFieldElement<T>>
extends FieldAbstractDetector<FieldLatitudeCrossingDetector<T>, T> {
    private OneAxisEllipsoid body;
    private final double latitude;

    public FieldLatitudeCrossingDetector(Field<T> field, OneAxisEllipsoid body, double latitude) {
        this((RealFieldElement)((RealFieldElement)field.getZero()).add(600.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-6), body, latitude);
    }

    public FieldLatitudeCrossingDetector(T maxCheck, T threshold, OneAxisEllipsoid body, double latitude) {
        this(maxCheck, threshold, 100, new FieldStopOnIncreasing(), body, latitude);
    }

    private FieldLatitudeCrossingDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldLatitudeCrossingDetector<T>, T> handler, OneAxisEllipsoid body, double latitude) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.latitude = latitude;
    }

    @Override
    protected FieldLatitudeCrossingDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldLatitudeCrossingDetector<T>, T> newHandler) {
        return new FieldLatitudeCrossingDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.latitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldGeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        return (T)((RealFieldElement)gp.getLatitude().subtract(this.latitude));
    }
}

