/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldApsideDetector<T extends RealFieldElement<T>>
extends FieldAbstractDetector<FieldApsideDetector<T>, T> {
    public FieldApsideDetector(FieldOrbit<T> orbit) {
        this((RealFieldElement)orbit.getKeplerianPeriod().multiply(1.0E-13), orbit);
    }

    public FieldApsideDetector(T threshold, FieldOrbit<T> orbit) {
        super((RealFieldElement)orbit.getKeplerianPeriod().divide(3.0), threshold, 100, new FieldStopOnIncreasing());
    }

    private FieldApsideDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldApsideDetector<T>, T> handler) {
        super(maxCheck, threshold, maxIter, handler);
    }

    @Override
    protected FieldApsideDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldApsideDetector<T>, T> newHandler) {
        return new FieldApsideDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        TimeStampedFieldPVCoordinates<T> pv = s.getPVCoordinates();
        return (T)FieldVector3D.dotProduct(pv.getPosition(), pv.getVelocity());
    }
}

