/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AlignmentDetector
extends AbstractDetector<AlignmentDetector> {
    private final PVCoordinatesProvider body;
    private final double alignAngle;
    private final double cosAlignAngle;
    private final double sinAlignAngle;

    public AlignmentDetector(Orbit orbit, PVCoordinatesProvider body, double alignAngle) {
        this(1.0E-13 * orbit.getKeplerianPeriod(), orbit, body, alignAngle);
    }

    public AlignmentDetector(double maxCheck, double threshold, PVCoordinatesProvider body, double alignAngle) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body, alignAngle);
    }

    public AlignmentDetector(double threshold, Orbit orbit, PVCoordinatesProvider body, double alignAngle) {
        this(orbit.getKeplerianPeriod() / 3.0, threshold, body, alignAngle);
    }

    private AlignmentDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super AlignmentDetector> handler, PVCoordinatesProvider body, double alignAngle) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.alignAngle = alignAngle;
        this.cosAlignAngle = FastMath.cos((double)alignAngle);
        this.sinAlignAngle = FastMath.sin((double)alignAngle);
    }

    @Override
    protected AlignmentDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super AlignmentDetector> newHandler) {
        return new AlignmentDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.alignAngle);
    }

    public PVCoordinatesProvider getPVCoordinatesProvider() {
        return this.body;
    }

    public double getAlignAngle() {
        return this.alignAngle;
    }

    @Override
    public double g(SpacecraftState s) {
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        Vector3D a = pv.getPosition().normalize();
        Vector3D b = Vector3D.crossProduct((Vector3D)pv.getMomentum(), (Vector3D)a).normalize();
        Vector3D x = new Vector3D(this.cosAlignAngle, a, this.sinAlignAngle, b);
        Vector3D y = new Vector3D(this.sinAlignAngle, a, -this.cosAlignAngle, b);
        Vector3D pb = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        double beta = FastMath.atan2((double)Vector3D.dotProduct((Vector3D)pb, (Vector3D)y), (double)Vector3D.dotProduct((Vector3D)pb, (Vector3D)x));
        double betm = -Math.PI - beta;
        double betp = Math.PI - beta;
        if (beta < betm) {
            return betm;
        }
        if (beta < betp) {
            return beta;
        }
        return betp;
    }
}

