/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.ode.events.Action;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorConverter;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedPVCoordinates;

public class JacobianPropagatorConverter
extends AbstractPropagatorConverter {
    private final NumericalPropagatorBuilder builder;

    public JacobianPropagatorConverter(NumericalPropagatorBuilder builder, double threshold, int maxIterations) {
        super(builder, threshold, maxIterations);
        if (builder.getOrbitType() != OrbitType.CARTESIAN) {
            throw new OrekitException((Localizable)OrekitMessages.ORBIT_TYPE_NOT_ALLOWED, new Object[]{builder.getOrbitType(), OrbitType.CARTESIAN});
        }
        this.builder = builder;
    }

    @Override
    protected MultivariateVectorFunction getObjectiveFunction() {
        return new MultivariateVectorFunction(){

            public double[] value(double[] arg) throws IllegalArgumentException, OrekitException {
                final double[] value = new double[JacobianPropagatorConverter.this.getTargetSize()];
                NumericalPropagator prop = JacobianPropagatorConverter.this.builder.buildPropagator(arg);
                final int stateSize = JacobianPropagatorConverter.this.isOnlyPosition() ? 3 : 6;
                List<SpacecraftState> sample = JacobianPropagatorConverter.this.getSample();
                for (int i = 0; i < sample.size(); ++i) {
                    final int row = i * stateSize;
                    if (prop.getInitialState().getDate().equals(sample.get(i).getDate())) {
                        JacobianPropagatorConverter.this.fillRows(value, row, prop.getInitialState());
                        continue;
                    }
                    prop.addEventDetector(new DateDetector(sample.get(i).getDate()).withHandler(new EventHandler<DateDetector>(){

                        @Override
                        public Action eventOccurred(SpacecraftState state, DateDetector detector, boolean increasing) {
                            JacobianPropagatorConverter.this.fillRows(value, row, state);
                            return row + stateSize >= JacobianPropagatorConverter.this.getTargetSize() ? Action.STOP : Action.CONTINUE;
                        }
                    }));
                }
                prop.propagate(sample.get(sample.size() - 1).getDate().shiftedBy(10.0));
                return value;
            }
        };
    }

    @Override
    protected MultivariateJacobianFunction getModel() {
        return new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) throws IllegalArgumentException, OrekitException {
                ArrayRealVector value = new ArrayRealVector(JacobianPropagatorConverter.this.getTargetSize());
                RealMatrix jacobian = MatrixUtils.createRealMatrix((int)JacobianPropagatorConverter.this.getTargetSize(), (int)point.getDimension());
                NumericalPropagator prop = JacobianPropagatorConverter.this.builder.buildPropagator(point.toArray());
                int stateSize = JacobianPropagatorConverter.this.isOnlyPosition() ? 3 : 6;
                ParameterDriversList orbitalParameters = JacobianPropagatorConverter.this.builder.getOrbitalParametersDrivers();
                PartialDerivativesEquations pde = new PartialDerivativesEquations("pde", prop);
                ParameterDriversList propagationParameters = pde.getSelectedParameters();
                prop.setInitialState(pde.setInitialJacobians(prop.getInitialState()));
                JacobiansMapper mapper = pde.getMapper();
                List<SpacecraftState> sample = JacobianPropagatorConverter.this.getSample();
                for (int i = 0; i < sample.size(); ++i) {
                    int row = i * stateSize;
                    if (prop.getInitialState().getDate().equals(sample.get(i).getDate())) {
                        JacobianPropagatorConverter.this.fillRows((RealVector)value, jacobian, row, prop.getInitialState(), stateSize, orbitalParameters, propagationParameters, mapper);
                        continue;
                    }
                    prop.addEventDetector(new DateDetector(sample.get(i).getDate()).withHandler(new EventHandler<DateDetector>((RealVector)value, jacobian, row, stateSize, orbitalParameters, propagationParameters, mapper){
                        final /* synthetic */ RealVector val$value;
                        final /* synthetic */ RealMatrix val$jacobian;
                        final /* synthetic */ int val$row;
                        final /* synthetic */ int val$stateSize;
                        final /* synthetic */ ParameterDriversList val$orbitalParameters;
                        final /* synthetic */ ParameterDriversList val$propagationParameters;
                        final /* synthetic */ JacobiansMapper val$mapper;
                        {
                            this.val$value = realVector;
                            this.val$jacobian = realMatrix;
                            this.val$row = n;
                            this.val$stateSize = n2;
                            this.val$orbitalParameters = parameterDriversList;
                            this.val$propagationParameters = parameterDriversList2;
                            this.val$mapper = jacobiansMapper;
                        }

                        @Override
                        public Action eventOccurred(SpacecraftState state, DateDetector detector, boolean increasing) {
                            JacobianPropagatorConverter.this.fillRows(this.val$value, this.val$jacobian, this.val$row, state, this.val$stateSize, this.val$orbitalParameters, this.val$propagationParameters, this.val$mapper);
                            return this.val$row + this.val$stateSize >= JacobianPropagatorConverter.this.getTargetSize() ? Action.STOP : Action.CONTINUE;
                        }
                    }));
                }
                prop.propagate(sample.get(sample.size() - 1).getDate().shiftedBy(10.0));
                return new Pair((Object)value, (Object)jacobian);
            }
        };
    }

    private void fillRows(double[] value, int row, SpacecraftState state) {
        TimeStampedPVCoordinates pv = state.getPVCoordinates(this.getFrame());
        value[row] = pv.getPosition().getX();
        value[row + 1] = pv.getPosition().getY();
        value[row + 2] = pv.getPosition().getZ();
        if (!this.isOnlyPosition()) {
            value[row + 3] = pv.getVelocity().getX();
            value[row + 4] = pv.getVelocity().getY();
            value[row + 5] = pv.getVelocity().getZ();
        }
    }

    private void fillRows(RealVector value, RealMatrix jacobian, int row, SpacecraftState state, int stateSize, ParameterDriversList orbitalParameters, ParameterDriversList propagationParameters, JacobiansMapper mapper) {
        TimeStampedPVCoordinates pv = state.getPVCoordinates(this.getFrame());
        value.setEntry(row, pv.getPosition().getX());
        value.setEntry(row + 1, pv.getPosition().getY());
        value.setEntry(row + 2, pv.getPosition().getZ());
        if (!this.isOnlyPosition()) {
            value.setEntry(row + 3, pv.getVelocity().getX());
            value.setEntry(row + 4, pv.getVelocity().getY());
            value.setEntry(row + 5, pv.getVelocity().getZ());
        }
        double[][] dYdY0 = new double[6][6];
        double[][] dYdP = new double[6][mapper.getParameters()];
        mapper.getStateJacobian(state, dYdY0);
        mapper.getParametersJacobian(state, dYdP);
        for (int k = 0; k < stateSize; ++k) {
            ParameterDriver driver;
            int j;
            int index = 0;
            for (j = 0; j < orbitalParameters.getNbParams(); ++j) {
                driver = orbitalParameters.getDrivers().get(j);
                if (!driver.isSelected()) continue;
                jacobian.setEntry(row + k, index++, dYdY0[k][j] * driver.getScale());
            }
            for (j = 0; j < propagationParameters.getNbParams(); ++j) {
                driver = propagationParameters.getDrivers().get(j);
                jacobian.setEntry(row + k, index++, dYdP[k][j] * driver.getScale());
            }
        }
    }
}

