/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.models.earth.tessellation.TileAiming;

public class ConstantAzimuthAiming
implements TileAiming {
    private final double cos;
    private final double sin;

    public ConstantAzimuthAiming(OneAxisEllipsoid ellipsoid, double azimuth) {
        this.cos = FastMath.cos((double)azimuth);
        this.sin = FastMath.sin((double)azimuth);
    }

    @Override
    public List<GeodeticPoint> getSingularPoints() {
        return Arrays.asList(GeodeticPoint.NORTH_POLE, GeodeticPoint.SOUTH_POLE);
    }

    @Override
    public Vector3D alongTileDirection(Vector3D point, GeodeticPoint gp) {
        return new Vector3D(this.cos, gp.getNorth(), this.sin, gp.getEast());
    }
}

