/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.util.FastMath;
import org.orekit.models.AtmosphericRefractionModel;

public class EarthStandardAtmosphereRefraction
implements AtmosphericRefractionModel {
    public static final double DEFAULT_CORRECTION_FACTOR = 1.0;
    public static final double DEFAULT_PRESSURE = 101000.0;
    public static final double DEFAULT_TEMPERATURE = 283.0;
    public static final double STANDARD_ATM_PRESSURE = 101325.0;
    public static final double STANDARD_ATM_TEMPERATURE = 293.15;
    private static final double MIN_ELEVATION = -2.0;
    private static final double MAX_ELEVATION = 89.89;
    private static final long serialVersionUID = 6001744143210742620L;
    private double correfrac;
    private double pressure;
    private double temperature;

    public EarthStandardAtmosphereRefraction() {
        this.correfrac = 1.0;
        this.pressure = 101000.0;
        this.temperature = 283.0;
    }

    public EarthStandardAtmosphereRefraction(double pressure, double temperature) {
        this.setTemperature(temperature);
        this.setPressure(pressure);
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
        this.correfrac = pressure / 101000.0 * (283.0 / this.temperature);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
        this.correfrac = this.pressure / 101000.0 * (283.0 / temperature);
    }

    @Override
    public double getRefraction(double trueElevation) {
        double refraction = 0.0;
        double eld = FastMath.toDegrees((double)trueElevation);
        if (eld > -2.0 && eld < 89.89) {
            double tmp = eld + 10.3 / (eld + 5.11);
            double ref = 1.02 / FastMath.tan((double)FastMath.toRadians((double)tmp)) / 60.0;
            refraction = FastMath.toRadians((double)(this.correfrac * ref));
        }
        return refraction;
    }
}

