/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.gnss.antenna.PhaseCenterVariationFunction;

class TwoDVariation
implements PhaseCenterVariationFunction {
    private final double polarStart;
    private final double polarStep;
    private final double azimuthStep;
    private final double[][] variations;

    TwoDVariation(double polarStart, double polarStep, double azimuthStep, double[][] variations) {
        this.polarStart = polarStart;
        this.polarStep = polarStep;
        this.azimuthStep = azimuthStep;
        this.variations = new double[variations.length][];
        for (int i = 0; i < variations.length; ++i) {
            this.variations[i] = (double[])variations[i].clone();
        }
    }

    @Override
    public double value(double polarAngle, double azimuthAngle) {
        double az = MathUtils.normalizeAngle((double)azimuthAngle, (double)Math.PI);
        int iBase = (int)FastMath.floor((double)(az / this.azimuthStep));
        int i = FastMath.max((int)0, (int)FastMath.min((int)(this.variations.length - 2), (int)iBase));
        int jBase = (int)FastMath.floor((double)((polarAngle - this.polarStart) / this.polarStep));
        int j = FastMath.max((int)0, (int)FastMath.min((int)(this.variations[i].length - 2), (int)jBase));
        double aInf = (double)i * this.azimuthStep;
        double aSup = aInf + this.azimuthStep;
        double pInf = this.polarStart + (double)j * this.polarStep;
        double pSup = pInf + this.polarStep;
        double vInfInf = this.variations[i][j];
        double vInfSup = this.variations[i][j + 1];
        double vSupInf = this.variations[i + 1][j];
        double vSupSup = this.variations[i + 1][j + 1];
        double vInf = ((polarAngle - pInf) * vInfSup + (pSup - polarAngle) * vInfInf) / this.polarStep;
        double vSup = ((polarAngle - pInf) * vSupSup + (pSup - polarAngle) * vSupInf) / this.polarStep;
        return ((az - aInf) * vSup + (aSup - az) * vInf) / this.azimuthStep;
    }
}

