/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeVectorFunction;
import org.orekit.utils.IERSConventions;

class TODProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20131209L;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeScalarFunction obliquityFunction;
    private final transient TimeVectorFunction nutationFunction;

    TODProvider(IERSConventions conventions, EOPHistory eopHistory) {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.obliquityFunction = conventions.getMeanObliquityFunction();
        this.nutationFunction = conventions.getNutationFunction();
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public TODProvider getNonInterpolatingProvider() {
        return new TODProvider(this.conventions, this.eopHistory.getNonInterpolatingEOPHistory());
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double[] angles = this.nutationFunction.value(date);
        double moe = this.obliquityFunction.value(date);
        double dpsi = angles[0];
        double deps = angles[1];
        if (this.eopHistory != null) {
            double[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dpsi += correction[0];
            deps += correction[1];
        }
        double toe = moe + deps;
        Rotation nutation = new Rotation(RotationOrder.XZX, RotationConvention.FRAME_TRANSFORM, moe, -dpsi, -toe);
        return new Transform(date, nutation);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        RealFieldElement[] angles = this.nutationFunction.value(date);
        T moe = this.obliquityFunction.value(date);
        RealFieldElement dpsi = angles[0];
        RealFieldElement deps = angles[1];
        if (this.eopHistory != null) {
            RealFieldElement[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dpsi = (RealFieldElement)dpsi.add((Object)correction[0]);
            deps = (RealFieldElement)deps.add((Object)correction[1]);
        }
        RealFieldElement toe = (RealFieldElement)moe.add((Object)deps);
        FieldRotation nutation = new FieldRotation(RotationOrder.XZX, RotationConvention.FRAME_TRANSFORM, moe, (RealFieldElement)dpsi.negate(), (RealFieldElement)toe.negate());
        return new FieldTransform<T>(date, nutation);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TODProvider(this.conventions, this.eopHistory);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

