/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.files.ccsds.ODMFile;
import org.orekit.files.ccsds.ODMMetaData;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OEMFile
extends ODMFile
implements EphemerisFile {
    private List<EphemeridesBlock> ephemeridesBlocks = new ArrayList<EphemeridesBlock>();

    void addEphemeridesBlock() {
        this.ephemeridesBlocks.add(new EphemeridesBlock());
    }

    public List<EphemeridesBlock> getEphemeridesBlocks() {
        return Collections.unmodifiableList(this.ephemeridesBlocks);
    }

    void checkTimeSystems() {
        CcsdsTimeScale timeSystem = this.getEphemeridesBlocks().get(0).getMetaData().getTimeSystem();
        for (EphemeridesBlock block : this.ephemeridesBlocks) {
            if (timeSystem.equals((Object)block.getMetaData().getTimeSystem())) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_OEM_INCONSISTENT_TIME_SYSTEMS, new Object[]{timeSystem, block.getMetaData().getTimeSystem()});
        }
    }

    public Map<String, OemSatelliteEphemeris> getSatellites() {
        HashMap satellites = new HashMap();
        for (EphemeridesBlock ephemeridesBlock : this.ephemeridesBlocks) {
            String id = ephemeridesBlock.getMetaData().getObjectID();
            satellites.putIfAbsent(id, new ArrayList());
            ((List)satellites.get(id)).add(ephemeridesBlock);
        }
        HashMap<String, OemSatelliteEphemeris> ret = new HashMap<String, OemSatelliteEphemeris>();
        for (Map.Entry entry : satellites.entrySet()) {
            String id = (String)entry.getKey();
            ret.put(id, new OemSatelliteEphemeris(id, this.getMuUsed(), (List)entry.getValue()));
        }
        return ret;
    }

    public static class OemSatelliteEphemeris
    implements EphemerisFile.SatelliteEphemeris {
        private final String id;
        private final double mu;
        private final List<EphemeridesBlock> blocks;

        OemSatelliteEphemeris(String id, double mu, List<EphemeridesBlock> blocks) {
            this.id = id;
            this.mu = mu;
            this.blocks = blocks;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        public List<EphemeridesBlock> getSegments() {
            return Collections.unmodifiableList(this.blocks);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.blocks.get(0).getStart();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.blocks.get(this.blocks.size() - 1).getStop();
        }
    }

    public static class CovarianceMatrix {
        private RealMatrix matrix;
        private AbsoluteDate epoch;
        private LOFType lofType;
        private Frame frame;

        CovarianceMatrix(AbsoluteDate epoch, LOFType lofType, Frame frame, RealMatrix lastMatrix) {
            this.matrix = lastMatrix;
            this.epoch = epoch;
            this.lofType = lofType;
            this.frame = frame;
        }

        public RealMatrix getMatrix() {
            return this.matrix;
        }

        public AbsoluteDate getEpoch() {
            return this.epoch;
        }

        public LOFType getLofType() {
            return this.lofType;
        }

        public Frame getFrame() {
            return this.frame;
        }
    }

    public class EphemeridesBlock
    implements EphemerisFile.EphemerisSegment {
        private ODMMetaData metaData;
        private AbsoluteDate startTime;
        private AbsoluteDate stopTime;
        private AbsoluteDate useableStartTime;
        private AbsoluteDate useableStopTime;
        private String interpolationMethod;
        private int interpolationDegree;
        private List<TimeStampedPVCoordinates> ephemeridesDataLines;
        private boolean hasAcceleration;
        private List<CovarianceMatrix> covarianceMatrices;
        private boolean hasRefFrameEpoch;
        private List<String> ephemeridesDataLinesComment;

        public EphemeridesBlock() {
            this.metaData = new ODMMetaData(OEMFile.this);
            this.ephemeridesDataLines = new ArrayList<TimeStampedPVCoordinates>();
            this.covarianceMatrices = new ArrayList<CovarianceMatrix>();
            this.hasAcceleration = true;
        }

        List<TimeStampedPVCoordinates> getEphemeridesDataLines() {
            return this.ephemeridesDataLines;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return this.hasAcceleration ? CartesianDerivativesFilter.USE_PVA : CartesianDerivativesFilter.USE_PV;
        }

        void updateHasAcceleration(boolean pointHasAcceleration) {
            this.hasAcceleration = this.hasAcceleration && pointHasAcceleration;
        }

        public List<TimeStampedPVCoordinates> getCoordinates() {
            return Collections.unmodifiableList(this.ephemeridesDataLines);
        }

        public List<CovarianceMatrix> getCovarianceMatrices() {
            return this.covarianceMatrices;
        }

        public ODMMetaData getMetaData() {
            return this.metaData;
        }

        @Override
        public double getMu() {
            return OEMFile.this.getMuUsed();
        }

        @Override
        public String getFrameCenterString() {
            return this.getMetaData().getCenterName();
        }

        @Override
        public String getFrameString() {
            return this.getMetaData().getFrameString();
        }

        @Override
        public Frame getFrame() {
            return this.getMetaData().getFrame();
        }

        @Override
        public String getTimeScaleString() {
            return this.getMetaData().getTimeSystem().toString();
        }

        @Override
        public TimeScale getTimeScale() {
            return this.getMetaData().getTimeSystem().getTimeScale(OEMFile.this.getConventions());
        }

        public AbsoluteDate getStartTime() {
            return this.startTime;
        }

        void setStartTime(AbsoluteDate startTime) {
            this.startTime = startTime;
        }

        public AbsoluteDate getStopTime() {
            return this.stopTime;
        }

        void setStopTime(AbsoluteDate stopTime) {
            this.stopTime = stopTime;
        }

        public AbsoluteDate getUseableStartTime() {
            return this.useableStartTime;
        }

        void setUseableStartTime(AbsoluteDate useableStartTime) {
            this.useableStartTime = useableStartTime;
        }

        public AbsoluteDate getUseableStopTime() {
            return this.useableStopTime;
        }

        void setUseableStopTime(AbsoluteDate useableStopTime) {
            this.useableStopTime = useableStopTime;
        }

        @Override
        public AbsoluteDate getStart() {
            AbsoluteDate start = this.getUseableStartTime();
            if (start != null) {
                return start;
            }
            return this.getStartTime();
        }

        @Override
        public AbsoluteDate getStop() {
            AbsoluteDate stop = this.getUseableStopTime();
            if (stop != null) {
                return stop;
            }
            return this.getStopTime();
        }

        public String getInterpolationMethod() {
            return this.interpolationMethod;
        }

        void setInterpolationMethod(String interpolationMethod) {
            this.interpolationMethod = interpolationMethod;
        }

        public int getInterpolationDegree() {
            return this.interpolationDegree;
        }

        void setInterpolationDegree(int interpolationDegree) {
            this.interpolationDegree = interpolationDegree;
        }

        @Override
        public int getInterpolationSamples() {
            return this.getInterpolationDegree() + 1;
        }

        public boolean getHasRefFrameEpoch() {
            return this.hasRefFrameEpoch;
        }

        void setHasRefFrameEpoch(boolean hasRefFrameEpoch) {
            this.hasRefFrameEpoch = hasRefFrameEpoch;
        }

        public List<String> getEphemeridesDataLinesComment() {
            return this.ephemeridesDataLinesComment;
        }

        void setEphemeridesDataLinesComment(List<String> ephemeridesDataLinesComment) {
            this.ephemeridesDataLinesComment = new ArrayList<String>(ephemeridesDataLinesComment);
        }
    }
}

