/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.IERSConventions;

public enum CcsdsTimeScale {
    GMST{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getGMST(conventions, false);
        }
    }
    ,
    GPS{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getGPS();
        }
    }
    ,
    MET{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate) {
            DateTimeComponents clock = DateTimeComponents.parseDateTime(date);
            double offset = (double)clock.getDate().getYear() * 3.15576E7 + (double)clock.getDate().getDayOfYear() * 86400.0 + clock.getTime().getSecondsInUTCDay();
            return missionReferenceDate.shiftedBy(offset);
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, "MET");
        }
    }
    ,
    MRT{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate) {
            DateTimeComponents clock = DateTimeComponents.parseDateTime(date);
            double offset = (double)clock.getDate().getYear() * 3.15576E7 + (double)clock.getDate().getDayOfYear() * 86400.0 + clock.getTime().getSecondsInUTCDay();
            return missionReferenceDate.shiftedBy(offset);
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, "MRT");
        }
    }
    ,
    SCLK{

        @Override
        public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED, this.name());
        }

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_NO_CORRESPONDING_TIME_SCALE, this.name());
        }
    }
    ,
    TAI{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getTAI();
        }
    }
    ,
    TCB{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getTCB();
        }
    }
    ,
    TDB{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getTDB();
        }
    }
    ,
    TCG{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getTCG();
        }
    }
    ,
    TT{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getTT();
        }
    }
    ,
    UT1{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getUT1(conventions, false);
        }
    }
    ,
    UTC{

        @Override
        public TimeScale getTimeScale(IERSConventions conventions) {
            return TimeScalesFactory.getUTC();
        }
    };


    public AbsoluteDate parseDate(String date, IERSConventions conventions, AbsoluteDate missionReferenceDate) {
        return new AbsoluteDate(date, this.getTimeScale(conventions));
    }

    public abstract TimeScale getTimeScale(IERSConventions var1);

    public static boolean contains(String timeScale) {
        for (CcsdsTimeScale scale : CcsdsTimeScale.values()) {
            if (!scale.name().equals(timeScale)) continue;
            return true;
        }
        return false;
    }
}

