/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.IonosphericDSConverter;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class RangeRateIonosphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final IonosphericModel ionoModel;
    private final double frequency;
    private final double fTwoWay;

    public RangeRateIonosphericDelayModifier(IonosphericModel model, double freq, boolean twoWay) {
        this.ionoModel = model;
        this.frequency = freq;
        this.fTwoWay = twoWay ? 2.0 : 1.0;
    }

    private double rangeRateErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay1 = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        SpacecraftState state2 = state.shiftedBy(10.0);
        double delay2 = this.ionoModel.pathDelay(state2, baseFrame, this.frequency, this.ionoModel.getParameters());
        return this.fTwoWay * (delay2 - delay1) / 10.0;
    }

    private <T extends RealFieldElement<T>> T rangeRateErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        double dt = 10.0;
        TopocentricFrame baseFrame = station.getBaseFrame();
        RealFieldElement delay1 = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (RealFieldElement[])parameters);
        FieldTimeInterpolable state2 = state.shiftedBy(10.0);
        RealFieldElement delay2 = this.ionoModel.pathDelay((FieldSpacecraftState)state2, baseFrame, this.frequency, (RealFieldElement[])parameters);
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)delay2.subtract((Object)delay1)).divide(10.0)).multiply(this.fTwoWay));
    }

    private double[][] rangeRateErrorJacobianState(double[] derivatives, int freeStateParameters) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        for (int i = 0; i < freeStateParameters; ++i) {
            finiteDifferencesJacobian[0][i] = derivatives[i + 1];
        }
        return finiteDifferencesJacobian;
    }

    private double rangeRateErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return RangeRateIonosphericDelayModifier.this.rangeRateErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeRateErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - 1 - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[1 + freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        double parameterDerivative;
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        IonosphericDSConverter converter = new IonosphericDSConverter(state, 6, Propagator.DEFAULT_LAW);
        FieldSpacecraftState<DerivativeStructure> dsState = converter.getState(this.ionoModel);
        DerivativeStructure[] dsParameters = converter.getParameters(dsState, this.ionoModel);
        DerivativeStructure dsDelay = (DerivativeStructure)this.rangeRateErrorIonosphericModel(station, dsState, (RealFieldElement[])dsParameters);
        double[] derivatives = dsDelay.getAllDerivatives();
        double[][] djac = this.rangeRateErrorJacobianState(derivatives, converter.getFreeStateParameters());
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.rangeRateErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeRateErrorParameterDerivative(station, driver, state));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + dsDelay.getValue();
        estimated.setEstimatedValue(newValue);
    }
}

