/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.utils.ParameterDriver;

public class OutlierFilter<T extends ObservedMeasurement<T>>
implements EstimationModifier<T> {
    private final int warmup;
    private final double maxSigma;

    public OutlierFilter(int warmup, double maxSigma) {
        this.warmup = warmup;
        this.maxSigma = maxSigma;
    }

    protected int getWarmup() {
        return this.warmup;
    }

    protected double getMaxSigma() {
        return this.maxSigma;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<T> estimated) {
        if (estimated.getIteration() > this.warmup) {
            double[] observed = estimated.getObservedMeasurement().getObservedValue();
            double[] theoretical = estimated.getEstimatedValue();
            double[] sigma = estimated.getObservedMeasurement().getTheoreticalStandardDeviation();
            for (int i = 0; i < observed.length; ++i) {
                if (!(FastMath.abs((double)(observed[i] - theoretical[i])) > this.maxSigma * sigma[i])) continue;
                estimated.setStatus(EstimatedMeasurement.Status.REJECTED);
            }
        }
    }
}

