/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Range
extends AbstractMeasurement<Range> {
    private final GroundStation station;
    private final boolean twoway;

    public Range(GroundStation station, boolean twoWay, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, range, sigma, baseWeight, Arrays.asList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        if (!twoWay) {
            this.addParameterDriver(satellite.getClockOffsetDriver());
        }
        this.station = station;
        this.twoway = twoWay;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    @Override
    protected EstimatedMeasurement<Range> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        DerivativeStructure range;
        EstimatedMeasurement<Range> estimated;
        ObservableSatellite satellite = this.getSatellites().get(0);
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field field = factory.getDerivativeField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = Range.getCoordinates(state, 0, factory);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), factory, indices);
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        DerivativeStructure tauD = Range.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        DerivativeStructure delta = downlinkDateDS.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        if (this.twoway) {
            FieldPVCoordinates stationAtTransitDate = stationDownlink.shiftedBy((RealFieldElement)tauD.negate());
            DerivativeStructure tauU = (DerivativeStructure)Range.signalTimeOfFlight(stationAtTransitDate, transitStateDS.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateDS).getDate());
            FieldPVCoordinates stationUplink = stationDownlink.shiftedBy(-tauD.getValue() - tauU.getValue());
            estimated = new EstimatedMeasurement<Range>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)stationUplink).toTimeStampedPVCoordinates(), ((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
            double cOver2 = 1.49896229E8;
            DerivativeStructure tau = tauD.add(tauU);
            range = tau.multiply(1.49896229E8);
        } else {
            estimated = new EstimatedMeasurement<Range>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
            DerivativeStructure dtg = this.station.getClockOffsetDriver().getValue(factory, indices);
            DerivativeStructure dts = satellite.getClockOffsetDriver().getValue(factory, indices);
            range = tauD.add(dtg).subtract(dts).multiply(2.99792458E8);
        }
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index + 1]);
        }
        return estimated;
    }
}

